/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import com.google.inject.Inject;
import id.onyx.obdp.server.api.services.PersistKeyValueImpl;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import id.onyx.obdp.server.utils.StageUtils;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/persist/")
public class PersistKeyValueService {
    private static PersistKeyValueImpl persistKeyVal;
    private static final Logger LOG;

    @Inject
    public static void init(PersistKeyValueImpl instance) {
        persistKeyVal = instance;
    }

    @POST
    @Produces(value={"text/plain"})
    public Response update(String keyValues) throws WebApplicationException, InvalidStateTransitionException, JAXBException, IOException {
        LOG.debug("Received message from UI {}", (Object)keyValues);
        Map keyValuesMap = StageUtils.fromJson(keyValues, Map.class);
        for (Map.Entry keyValue : keyValuesMap.entrySet()) {
            persistKeyVal.put((String)keyValue.getKey(), (String)keyValue.getValue());
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @PUT
    @Produces(value={"text/plain"})
    public String store(String values) throws IOException, JAXBException {
        LOG.debug("Received message from UI {}", (Object)values);
        Collection valueCollection = StageUtils.fromJson(values, Collection.class);
        ArrayList<String> keys = new ArrayList<String>(valueCollection.size());
        for (String s : valueCollection) {
            keys.add(persistKeyVal.put(s));
        }
        String stringRet = StageUtils.jaxbToString(keys);
        LOG.debug("Returning {}", (Object)stringRet);
        return stringRet;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{keyName}")
    public String getKey(@PathParam(value="keyName") String keyName) {
        LOG.debug("Looking for keyName {}", (Object)keyName);
        return persistKeyVal.getValue(keyName);
    }

    @GET
    @Produces(value={"text/plain"})
    public String getAllKeyValues() throws JAXBException, IOException {
        Map<String, String> ret = persistKeyVal.getAllKeyValues();
        String stringRet = StageUtils.jaxbToString(ret);
        LOG.debug("Returning {}", (Object)stringRet);
        return stringRet;
    }

    static {
        LOG = LoggerFactory.getLogger(PersistKeyValueService.class);
    }
}

