/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.orm.dao.KeyValueDAO;
import id.onyx.obdp.server.orm.entities.KeyValueEntity;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Singleton
public class PersistKeyValueImpl {
    @Inject
    KeyValueDAO keyValueDAO;

    public String generateKey() {
        return UUID.randomUUID().toString();
    }

    public Collection<String> generateKeys(int number) {
        ArrayList<String> keys = new ArrayList<String>(number);
        for (int i = 0; i < number; ++i) {
            keys.add(this.generateKey());
        }
        return keys;
    }

    public synchronized String getValue(String key) {
        KeyValueEntity keyValueEntity = this.keyValueDAO.findByKey(key);
        if (keyValueEntity != null) {
            return keyValueEntity.getValue();
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    public synchronized String put(String value) {
        String key = this.generateKey();
        this.put(key, value);
        return key;
    }

    public synchronized void put(String key, String value) {
        KeyValueEntity keyValueEntity = this.keyValueDAO.findByKey(key);
        if (keyValueEntity != null) {
            keyValueEntity.setValue(value);
            this.keyValueDAO.merge(keyValueEntity);
        } else {
            keyValueEntity = new KeyValueEntity();
            keyValueEntity.setKey(key);
            keyValueEntity.setValue(value);
            this.keyValueDAO.create(keyValueEntity);
        }
    }

    public synchronized Map<String, String> getAllKeyValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (KeyValueEntity keyValueEntity : this.keyValueDAO.findAll()) {
            map.put(keyValueEntity.getKey(), keyValueEntity.getValue());
        }
        return map;
    }
}

