/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.RoleAuthorizationService;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/permissions/")
public class PermissionService
extends BaseService {
    @GET
    @Path(value="{permissionId}")
    @Produces(value={"text/plain"})
    public Response getPermission(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="permissionId") String permissionId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createPermissionResource(permissionId));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getPermissions(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createPermissionResource(null));
    }

    @POST
    @Path(value="{permissionId}")
    @Produces(value={"text/plain"})
    public Response createPermission(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="permissionId") String permissionId) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createPermissionResource(permissionId));
    }

    @PUT
    @Path(value="{permissionId}")
    @Produces(value={"text/plain"})
    public Response updatePermission(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="permissionId") String permissionId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createPermissionResource(permissionId));
    }

    @DELETE
    @Path(value="{permissionId}")
    @Produces(value={"text/plain"})
    public Response deletePermission(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="permissionId") String permissionId) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createPermissionResource(permissionId));
    }

    @Path(value="{permissionId}/authorizations")
    public RoleAuthorizationService getRoleAuthorizations(@Context Request request, @PathParam(value="permissionId") String permissionId) {
        return new RoleAuthorizationService(permissionId);
    }

    protected ResourceInstance createPermissionResource(String permissionId) {
        return this.createResource(Resource.Type.Permission, Collections.singletonMap(Resource.Type.Permission, permissionId));
    }
}

