/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.RepositoryService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;

public class OperatingSystemService
extends BaseService {
    private Map<Resource.Type, String> parentKeyProperties;

    public OperatingSystemService(Map<Resource.Type, String> parentKeyProperties) {
        this.parentKeyProperties = parentKeyProperties;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getOperatingSystems(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(null));
    }

    @GET
    @Path(value="{osType}")
    @Produces(value={"text/plain"})
    public Response getOperatingSystem(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="osType") String osType) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(osType));
    }

    @Path(value="{osType}/repositories")
    public RepositoryService getOperatingSystemsHandler(@PathParam(value="osType") String osType) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.putAll(this.parentKeyProperties);
        mapIds.put(Resource.Type.OperatingSystem, osType);
        return new RepositoryService(mapIds);
    }

    private ResourceInstance createResource(String osType) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.putAll(this.parentKeyProperties);
        mapIds.put(Resource.Type.OperatingSystem, osType);
        return this.createResource(Resource.Type.OperatingSystem, mapIds);
    }
}

