/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ParentObjectNotFoundException;
import id.onyx.obdp.server.StackAccessException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.MpackRequest;
import id.onyx.obdp.server.controller.MpackResponse;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.customactions.ActionDefinition;
import id.onyx.obdp.server.customactions.ActionDefinitionManager;
import id.onyx.obdp.server.events.AlertDefinitionDisabledEvent;
import id.onyx.obdp.server.events.AlertDefinitionRegistrationEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.metadata.OBDPServiceAlertDefinitions;
import id.onyx.obdp.server.mpack.MpackManager;
import id.onyx.obdp.server.mpack.MpackManagerFactory;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.MpackEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.stack.StackManager;
import id.onyx.obdp.server.stack.StackManagerFactory;
import id.onyx.obdp.server.stack.upgrade.ConfigUpgradePack;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.DependencyInfo;
import id.onyx.obdp.server.state.ExtensionInfo;
import id.onyx.obdp.server.state.Module;
import id.onyx.obdp.server.state.Mpack;
import id.onyx.obdp.server.state.OperatingSystemInfo;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import id.onyx.obdp.server.state.alert.ScriptSource;
import id.onyx.obdp.server.state.alert.Source;
import id.onyx.obdp.server.state.alert.SourceType;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptorFactory;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.state.stack.Metric;
import id.onyx.obdp.server.state.stack.MetricDefinition;
import id.onyx.obdp.server.state.stack.OsFamily;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OBDPMetaInfo {
    public static final String ANY_OS = "any";
    public static final String SCHEMA_VERSION_2 = "2.0";
    public static final String KERBEROS_DESCRIPTOR_FILE_NAME = "kerberos.json";
    public static final String WIDGETS_DESCRIPTOR_FILE_NAME = "widgets.json";
    private static final Logger LOG = LoggerFactory.getLogger(OBDPMetaInfo.class);
    @Inject
    private OsFamily osFamily;
    private List<String> ALL_SUPPORTED_OS;
    private final ActionDefinitionManager adManager = new ActionDefinitionManager();
    private String serverVersion = "undefined";
    private File stackRoot;
    private File commonServicesRoot;
    private File extensionsRoot;
    private File serverVersionFile;
    private File commonWidgetsDescriptorFile;
    private File customActionRoot;
    private String commonKerberosDescriptorFileLocation;
    Map<String, VersionDefinitionXml> versionDefinitions = null;
    private File mpacksV2Staging;
    @Inject
    private AlertDefinitionDAO alertDefinitionDao;
    @Inject
    private AlertDefinitionFactory alertDefinitionFactory;
    @Inject
    private OBDPServiceAlertDefinitions ambariServiceAlertDefinitions;
    @Inject
    private OBDPEventPublisher eventPublisher;
    @Inject
    private KerberosDescriptorFactory kerberosDescriptorFactory;
    @Inject
    private KerberosServiceDescriptorFactory kerberosServiceDescriptorFactory;
    @Inject
    private StackManagerFactory stackManagerFactory;
    private StackManager stackManager;
    @Inject
    private MpackManagerFactory mpackManagerFactory;
    private MpackManager mpackManager;
    private Configuration conf;

    @Inject
    public OBDPMetaInfo(Configuration conf) throws Exception {
        String extensionsPath;
        this.conf = conf;
        String stackPath = conf.getMetadataPath();
        this.stackRoot = new File(stackPath);
        String commonServicesPath = conf.getCommonServicesPath();
        if (commonServicesPath != null && !commonServicesPath.isEmpty()) {
            this.commonServicesRoot = new File(commonServicesPath);
        }
        if ((extensionsPath = conf.getExtensionsPath()) != null && !extensionsPath.isEmpty()) {
            this.extensionsRoot = new File(extensionsPath);
        }
        String serverVersionFilePath = conf.getServerVersionFilePath();
        this.serverVersionFile = new File(serverVersionFilePath);
        this.customActionRoot = new File(conf.getCustomActionDefinitionPath());
        this.commonKerberosDescriptorFileLocation = new File(conf.getResourceDirPath(), KERBEROS_DESCRIPTOR_FILE_NAME).getAbsolutePath();
        this.commonWidgetsDescriptorFile = new File(conf.getResourceDirPath(), WIDGETS_DESCRIPTOR_FILE_NAME);
        String mpackV2StagingPath = conf.getMpacksV2StagingPath();
        this.mpacksV2Staging = new File(mpackV2StagingPath);
    }

    @Inject
    public void init() throws Exception {
        this.ALL_SUPPORTED_OS = new ArrayList<String>(this.osFamily.os_list());
        this.readServerVersion();
        this.stackManager = this.stackManagerFactory.create(this.stackRoot, this.commonServicesRoot, this.extensionsRoot, this.osFamily, false);
        this.mpackManager = this.mpackManagerFactory.create(this.mpacksV2Staging, this.stackRoot);
        this.getCustomActionDefinitions(this.customActionRoot);
    }

    public StackManager getStackManager() {
        return this.stackManager;
    }

    public MpackManager getMpackManager() {
        return this.mpackManager;
    }

    public List<ComponentInfo> getComponentsByService(String stackName, String version, String serviceName) throws OBDPException {
        ServiceInfo service;
        try {
            service = this.getService(stackName, version, serviceName);
        }
        catch (StackAccessException e) {
            throw new ParentObjectNotFoundException("Parent Service resource doesn't exist. stackName=" + stackName + ", stackVersion=" + version + ", serviceName=" + serviceName);
        }
        return service.getComponents();
    }

    public ComponentInfo getComponent(String stackName, String version, String serviceName, String componentName) throws OBDPException {
        ComponentInfo component = this.getService(stackName, version, serviceName).getComponentByName(componentName);
        if (component == null) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion=" + version + ", serviceName=" + serviceName + ", componentName=" + componentName);
        }
        return component;
    }

    public List<DependencyInfo> getComponentDependencies(String stackName, String version, String service, String component) throws OBDPException {
        ComponentInfo componentInfo;
        try {
            componentInfo = this.getComponent(stackName, version, service, component);
        }
        catch (StackAccessException e) {
            throw new ParentObjectNotFoundException("Parent Component resource doesn't exist", e);
        }
        return componentInfo.getDependencies();
    }

    public DependencyInfo getComponentDependency(String stackName, String version, String service, String component, String dependencyName) throws OBDPException {
        DependencyInfo foundDependency = null;
        List<DependencyInfo> componentDependencies = this.getComponentDependencies(stackName, version, service, component);
        Iterator<DependencyInfo> iter = componentDependencies.iterator();
        while (foundDependency == null && iter.hasNext()) {
            DependencyInfo dependency = iter.next();
            if (!dependencyName.equals(dependency.getComponentName())) continue;
            foundDependency = dependency;
        }
        if (foundDependency == null) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion= " + version + ", stackService=" + service + ", stackComponent= " + component + ", dependency=" + dependencyName);
        }
        return foundDependency;
    }

    public Map<String, List<RepositoryInfo>> getRepository(String stackName, String version) throws OBDPException {
        StackInfo stack = this.getStack(stackName, version);
        List<RepositoryInfo> repository = stack.getRepositories();
        HashMap<String, List<RepositoryInfo>> reposResult = new HashMap<String, List<RepositoryInfo>>();
        for (RepositoryInfo repo : repository) {
            if (!reposResult.containsKey(repo.getOsType())) {
                reposResult.put(repo.getOsType(), new ArrayList());
            }
            ((List)reposResult.get(repo.getOsType())).add(repo);
        }
        return reposResult;
    }

    public List<RepositoryInfo> getRepositories(String stackName, String version, String osType) throws OBDPException {
        StackInfo stack = this.getStack(stackName, version);
        List<RepositoryInfo> repositories = stack.getRepositories();
        ArrayList<RepositoryInfo> repositoriesResult = new ArrayList<RepositoryInfo>();
        for (RepositoryInfo repository : repositories) {
            if (!repository.getOsType().equals(osType)) continue;
            repositoriesResult.add(repository);
        }
        return repositoriesResult;
    }

    public RepositoryInfo getRepository(String stackName, String version, String osType, String repoId) throws OBDPException {
        List<RepositoryInfo> repositories = this.getRepositories(stackName, version, osType);
        if (repositories.size() == 0) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion=" + version + ", osType=" + osType + ", repoId=" + repoId);
        }
        RepositoryInfo repoResult = null;
        for (RepositoryInfo repository : repositories) {
            if (!repository.getRepoId().equals(repoId)) continue;
            repoResult = repository;
        }
        if (repoResult == null) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion= " + version + ", osType=" + osType + ", repoId= " + repoId);
        }
        return repoResult;
    }

    public boolean isSupportedStack(String stackName, String version) {
        try {
            this.getStack(stackName, version);
            return true;
        }
        catch (OBDPException e) {
            return false;
        }
    }

    public boolean isValidService(String stackName, String version, String serviceName) {
        try {
            this.getService(stackName, version, serviceName);
            return true;
        }
        catch (OBDPException e) {
            return false;
        }
    }

    public boolean isValidServiceComponent(String stackName, String version, String serviceName, String componentName) {
        try {
            this.getService(stackName, version, serviceName).getComponentByName(componentName);
            return true;
        }
        catch (OBDPException e) {
            return false;
        }
    }

    public String getComponentToService(String stackName, String version, String componentName) throws OBDPException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for service for component, stackName={}, stackVersion={}, componentName={}", new Object[]{stackName, version, componentName});
        }
        Map<String, ServiceInfo> services = this.getServices(stackName, version);
        String retService = null;
        if (services == null || services.isEmpty()) {
            return retService;
        }
        for (Map.Entry<String, ServiceInfo> entry : services.entrySet()) {
            ComponentInfo vu = entry.getValue().getComponentByName(componentName);
            if (vu == null) continue;
            retService = entry.getKey();
            break;
        }
        return retService;
    }

    public Map<String, ServiceInfo> getServices(String stackName, String version) throws OBDPException {
        StackInfo stack;
        HashMap<String, ServiceInfo> servicesInfoResult = new HashMap<String, ServiceInfo>();
        try {
            stack = this.getStack(stackName, version);
        }
        catch (StackAccessException e) {
            throw new ParentObjectNotFoundException("Parent Stack Version resource doesn't exist", e);
        }
        Collection<ServiceInfo> services = stack.getServices();
        if (services != null) {
            for (ServiceInfo service : services) {
                servicesInfoResult.put(service.getName(), service);
            }
        }
        return servicesInfoResult;
    }

    public ServiceInfo getService(Service service) throws OBDPException {
        StackId stackId = service.getDesiredStackId();
        return this.getService(stackId.getStackName(), stackId.getStackVersion(), service.getName());
    }

    public ServiceInfo getService(String stackName, String version, String serviceName) throws OBDPException {
        ServiceInfo service = this.getStack(stackName, version).getService(serviceName);
        if (service == null) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion=" + version + ", serviceName=" + serviceName);
        }
        return service;
    }

    public boolean isServiceRemovedInStack(String stackName, String version, String serviceName) throws OBDPException {
        StackInfo stack = this.getStack(stackName, version);
        List<String> removedServices = stack.getRemovedServices();
        return removedServices.contains(serviceName);
    }

    public boolean isServiceWithNoConfigs(String stackName, String version, String serviceName) throws OBDPException {
        StackInfo stack = this.getStack(stackName, version);
        List<String> servicesWithNoConfigs = stack.getServicesWithNoConfigs();
        return servicesWithNoConfigs.contains(serviceName);
    }

    public Collection<String> getMonitoringServiceNames(String stackName, String version) throws OBDPException {
        ArrayList<String> monitoringServices = new ArrayList<String>();
        for (ServiceInfo service : this.getServices(stackName, version).values()) {
            if (service.isMonitoringService() == null || !service.isMonitoringService().booleanValue()) continue;
            monitoringServices.add(service.getName());
        }
        return monitoringServices;
    }

    public Set<String> getRestartRequiredServicesNames(String stackName, String version) throws OBDPException {
        HashSet<String> needRestartServices = new HashSet<String>();
        Collection<ServiceInfo> serviceInfos = this.getServices(stackName, version).values();
        for (ServiceInfo service : serviceInfos) {
            Boolean restartRequiredAfterChange = service.isRestartRequiredAfterChange();
            if (restartRequiredAfterChange == null || !restartRequiredAfterChange.booleanValue()) continue;
            needRestartServices.add(service.getName());
        }
        return needRestartServices;
    }

    public Set<String> getRackSensitiveServicesNames(String stackName, String version) throws OBDPException {
        HashSet<String> needRestartServices = new HashSet<String>();
        Collection<ServiceInfo> serviceInfos = this.getServices(stackName, version).values();
        for (ServiceInfo service : serviceInfos) {
            Boolean restartRequiredAfterRackChange = service.isRestartRequiredAfterRackChange();
            if (restartRequiredAfterRackChange == null || !restartRequiredAfterRackChange.booleanValue()) continue;
            needRestartServices.add(service.getName());
        }
        return needRestartServices;
    }

    public Collection<StackInfo> getStacks() {
        return this.stackManager.getStacks();
    }

    public MpackResponse registerMpack(MpackRequest mpackRequest) throws IOException, ResourceAlreadyExistsException {
        if (this.versionDefinitions != null) {
            this.versionDefinitions.clear();
        }
        return this.mpackManager.registerMpack(mpackRequest);
    }

    public List<Module> getModules(Long mpackId) {
        return this.mpackManager.getModules(mpackId);
    }

    public Collection<StackInfo> getStacks(String stackName) throws OBDPException {
        Collection<StackInfo> stacks = this.stackManager.getStacks(stackName);
        if (stacks.isEmpty()) {
            throw new StackAccessException("stackName=" + stackName);
        }
        return stacks;
    }

    public StackInfo getStack(StackId stackId) throws OBDPException {
        return this.getStack(stackId.getStackName(), stackId.getStackVersion());
    }

    public StackInfo getStack(String stackName, String version) throws OBDPException {
        StackInfo stackInfoResult = this.stackManager.getStack(stackName, version);
        if (stackInfoResult == null) {
            throw new StackAccessException("Stack " + stackName + " " + version + " is not found in OBDP metainfo");
        }
        return stackInfoResult;
    }

    public List<String> getStackParentVersions(String stackName, String version) {
        ArrayList<String> parents = new ArrayList<String>();
        try {
            StackInfo stackInfo = this.getStack(stackName, version);
            String parentVersion = stackInfo.getParentStackVersion();
            if (parentVersion != null) {
                parents.add(parentVersion);
                parents.addAll(this.getStackParentVersions(stackName, parentVersion));
            }
        }
        catch (OBDPException oBDPException) {
            // empty catch block
        }
        return parents;
    }

    public Collection<ExtensionInfo> getExtensions() {
        return this.stackManager.getExtensions();
    }

    public Collection<ExtensionInfo> getExtensions(String extensionName) throws OBDPException {
        Collection<ExtensionInfo> extensions = this.stackManager.getExtensions(extensionName);
        if (extensions.isEmpty()) {
            throw new StackAccessException("extensionName=" + extensionName);
        }
        return extensions;
    }

    public ExtensionInfo getExtension(String extensionName, String version) throws OBDPException {
        ExtensionInfo result = this.stackManager.getExtension(extensionName, version);
        if (result == null) {
            throw new StackAccessException("Extension " + extensionName + " " + version + " is not found in OBDP metainfo");
        }
        return result;
    }

    public Set<PropertyInfo> getServiceProperties(String stackName, String version, String serviceName) throws OBDPException {
        return new HashSet<PropertyInfo>(this.getService(stackName, version, serviceName).getProperties());
    }

    public Set<PropertyInfo> getStackProperties(String stackName, String version) throws OBDPException {
        return new HashSet<PropertyInfo>(this.getStack(stackName, version).getProperties());
    }

    public Set<PropertyInfo> getPropertiesByName(String stackName, String version, String serviceName, String propertyName) throws OBDPException {
        Set<PropertyInfo> properties;
        Set<PropertyInfo> set = properties = serviceName == null ? this.getStackProperties(stackName, version) : this.getServiceProperties(stackName, version, serviceName);
        if (properties.size() == 0) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion=" + version + ", serviceName=" + serviceName + ", propertyName=" + propertyName);
        }
        HashSet<PropertyInfo> propertyResult = new HashSet<PropertyInfo>();
        for (PropertyInfo property : properties) {
            if (!property.getName().equals(propertyName)) continue;
            propertyResult.add(property);
        }
        if (propertyResult.isEmpty()) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion=" + version + ", serviceName=" + serviceName + ", propertyName=" + propertyName);
        }
        return propertyResult;
    }

    public Set<PropertyInfo> getStackPropertiesByName(String stackName, String version, String propertyName) throws OBDPException {
        Set<PropertyInfo> properties = this.getStackProperties(stackName, version);
        if (properties.size() == 0) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion=" + version + ", propertyName=" + propertyName);
        }
        HashSet<PropertyInfo> propertyResult = new HashSet<PropertyInfo>();
        for (PropertyInfo property : properties) {
            if (!property.getName().equals(propertyName)) continue;
            propertyResult.add(property);
        }
        if (propertyResult.isEmpty()) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion=" + version + ", propertyName=" + propertyName);
        }
        return propertyResult;
    }

    public Set<OperatingSystemInfo> getOperatingSystems(String stackName, String version) throws OBDPException {
        HashSet<OperatingSystemInfo> operatingSystems = new HashSet<OperatingSystemInfo>();
        StackInfo stack = this.getStack(stackName, version);
        List<RepositoryInfo> repositories = stack.getRepositories();
        for (RepositoryInfo repository : repositories) {
            operatingSystems.add(new OperatingSystemInfo(repository.getOsType()));
        }
        return operatingSystems;
    }

    public OperatingSystemInfo getOperatingSystem(String stackName, String version, String osType) throws OBDPException {
        Set<OperatingSystemInfo> operatingSystems = this.getOperatingSystems(stackName, version);
        if (operatingSystems.size() == 0) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion=" + version + ", osType=" + osType);
        }
        OperatingSystemInfo resultOperatingSystem = null;
        for (OperatingSystemInfo operatingSystem : operatingSystems) {
            if (!operatingSystem.getOsType().equals(osType)) continue;
            resultOperatingSystem = operatingSystem;
            break;
        }
        if (resultOperatingSystem == null) {
            throw new StackAccessException("stackName=" + stackName + ", stackVersion=" + version + ", osType=" + osType);
        }
        return resultOperatingSystem;
    }

    private void readServerVersion() throws Exception {
        File versionFile = this.serverVersionFile;
        if (!versionFile.exists()) {
            throw new OBDPException("Server version file does not exist.");
        }
        Scanner scanner = new Scanner(versionFile);
        this.serverVersion = scanner.useDelimiter("\\Z").next();
        scanner.close();
    }

    private void getCustomActionDefinitions(File customActionDefinitionRoot) throws JAXBException, OBDPException {
        if (customActionDefinitionRoot != null) {
            LOG.debug("Loading custom action definitions from {}", (Object)customActionDefinitionRoot.getAbsolutePath());
            if (customActionDefinitionRoot.exists() && customActionDefinitionRoot.isDirectory()) {
                this.adManager.readCustomActionDefinitions(customActionDefinitionRoot);
            } else {
                LOG.debug("No action definitions found at {}", (Object)customActionDefinitionRoot.getAbsolutePath());
            }
        }
    }

    public List<ActionDefinition> getAllActionDefinition() {
        return this.adManager.getAllActionDefinition();
    }

    public ActionDefinition getActionDefinition(String name) {
        return this.adManager.getActionDefinition(name);
    }

    public void addActionDefinition(ActionDefinition ad) throws OBDPException {
        this.adManager.addActionDefinition(ad);
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean isOsSupported(String osType) {
        return this.ALL_SUPPORTED_OS.contains(osType);
    }

    public File getStackRoot() {
        return this.stackRoot;
    }

    public File getExtensionsRoot() {
        return this.extensionsRoot;
    }

    public Map<String, Map<String, List<MetricDefinition>>> getServiceMetrics(String stackName, String stackVersion, String serviceName) throws OBDPException {
        ServiceInfo svc = this.getService(stackName, stackVersion, serviceName);
        if (null == svc.getMetricsFile() || !svc.getMetricsFile().exists()) {
            LOG.debug("Metrics file for {}/{}/{} not found.", new Object[]{stackName, stackVersion, serviceName});
            return null;
        }
        Map map = svc.getMetrics();
        if (null == map) {
            Type type = new TypeToken<Map<String, Map<String, List<MetricDefinition>>>>(){}.getType();
            Gson gson = new Gson();
            try {
                map = (Map)gson.fromJson((Reader)new FileReader(svc.getMetricsFile()), type);
                svc.setMetrics(this.processMetricDefinition(map));
            }
            catch (Exception e) {
                LOG.error("Could not read the metrics file", (Throwable)e);
                throw new OBDPException("Could not read metrics file", (Throwable)e);
            }
        }
        return map;
    }

    private Map<String, Map<String, List<MetricDefinition>>> processMetricDefinition(Map<String, Map<String, List<MetricDefinition>>> metricMap) {
        if (!metricMap.isEmpty()) {
            for (Map.Entry<String, Map<String, List<MetricDefinition>>> componentMetricDefEntry : metricMap.entrySet()) {
                String componentName = componentMetricDefEntry.getKey();
                for (Map.Entry<String, List<MetricDefinition>> metricDefEntry : componentMetricDefEntry.getValue().entrySet()) {
                    for (MetricDefinition metricDefinition : metricDefEntry.getValue()) {
                        for (Map.Entry<String, Map<String, Metric>> metricByCategory : metricDefinition.getMetricsByCategory().entrySet()) {
                            Iterator<Map.Entry<String, Metric>> iterator = metricByCategory.getValue().entrySet().iterator();
                            HashMap<String, Metric> newMetricsToAdd = new HashMap<String, Metric>();
                            while (iterator.hasNext()) {
                                Map.Entry<String, Metric> metricEntry = iterator.next();
                                Map<String, Metric> processedMetrics = PropertyHelper.processRpcMetricDefinition(metricDefinition.getType(), componentName, metricEntry.getKey(), metricEntry.getValue());
                                if (processedMetrics != null) {
                                    iterator.remove();
                                    newMetricsToAdd.putAll(processedMetrics);
                                } else {
                                    processedMetrics = Collections.singletonMap(metricEntry.getKey(), metricEntry.getValue());
                                }
                                if (!metricDefinition.getType().equals("ganglia") || !metricDefEntry.getKey().equals(Resource.InternalType.Component.name()) && !metricDefEntry.getKey().equals(Resource.InternalType.HostComponent.name())) continue;
                                for (Map.Entry<String, Metric> processedMetric : processedMetrics.entrySet()) {
                                    newMetricsToAdd.putAll(this.getAggregateFunctionMetrics(processedMetric.getKey(), processedMetric.getValue()));
                                }
                            }
                            metricByCategory.getValue().putAll(newMetricsToAdd);
                        }
                    }
                }
            }
        }
        return metricMap;
    }

    private Map<String, Metric> getAggregateFunctionMetrics(String metricName, Metric currentMetric) {
        HashMap<String, Metric> newMetrics = new HashMap<String, Metric>();
        if (!PropertyHelper.hasAggregateFunctionSuffix(currentMetric.getName())) {
            for (String identifierToAdd : PropertyHelper.AGGREGATE_FUNCTION_IDENTIFIERS) {
                String newMetricKey = metricName + identifierToAdd;
                Metric newMetric = new Metric(currentMetric.getName() + identifierToAdd, currentMetric.isPointInTime(), currentMetric.isTemporal(), currentMetric.isAmsHostMetric(), currentMetric.getUnit());
                newMetrics.put(newMetricKey, newMetric);
            }
        }
        return newMetrics;
    }

    public List<MetricDefinition> getMetrics(String stackName, String stackVersion, String serviceName, String componentName, String metricType) throws OBDPException {
        Map<String, Map<String, List<MetricDefinition>>> map = this.getServiceMetrics(stackName, stackVersion, serviceName);
        if (map != null && map.containsKey(componentName) && map.get(componentName).containsKey(metricType)) {
            return map.get(componentName).get(metricType);
        }
        return null;
    }

    public Set<AlertDefinition> getAlertDefinitions(String stackName, String stackVersion, String serviceName) throws OBDPException {
        ServiceInfo svc = this.getService(stackName, stackVersion, serviceName);
        return this.getAlertDefinitions(svc);
    }

    public Set<AlertDefinition> getAlertDefinitions(ServiceInfo service) throws OBDPException {
        File alertsFile = service.getAlertsFile();
        if (null == alertsFile || !alertsFile.exists()) {
            LOG.debug("Alerts file for {}/{} not found.", (Object)service.getSchemaVersion(), (Object)service.getName());
            return Collections.emptySet();
        }
        return this.alertDefinitionFactory.getAlertDefinitions(alertsFile, service.getName());
    }

    private List<AlertDefinitionEntity> getDefinitionsForMerge(List<AlertDefinition> definitions, long clusterId, Map<String, AlertDefinitionEntity> mappedEntities) {
        ArrayList<AlertDefinitionEntity> definitionsForMerge = new ArrayList<AlertDefinitionEntity>();
        for (AlertDefinition definition : definitions) {
            AlertDefinitionEntity entity = mappedEntities.get(definition.getName());
            if (null != entity) continue;
            entity = this.alertDefinitionFactory.coerce(clusterId, definition);
            definitionsForMerge.add(entity);
        }
        return definitionsForMerge;
    }

    public void reconcileAlertDefinitions(Clusters clusters, boolean updateScriptPaths) throws OBDPException {
        Map<String, Cluster> clusterMap = clusters.getClusters();
        if (null == clusterMap || clusterMap.size() == 0) {
            return;
        }
        for (Cluster cluster : clusterMap.values()) {
            this.reconcileAlertDefinitions(cluster, updateScriptPaths);
        }
    }

    public void reconcileAlertDefinitions(Cluster cluster, boolean updateScriptPaths) throws OBDPException {
        if (null == cluster) {
            return;
        }
        long clusterId = cluster.getClusterId();
        HashMap<String, ServiceInfo> stackServiceMap = new HashMap<String, ServiceInfo>();
        HashMap<String, ComponentInfo> stackComponentMap = new HashMap<String, ComponentInfo>();
        ArrayList<AlertDefinition> stackDefinitions = new ArrayList<AlertDefinition>(50);
        for (Service service : cluster.getServices().values()) {
            ServiceInfo stackService = this.getService(service.getDesiredStackId().getStackName(), service.getDesiredStackId().getStackVersion(), service.getName());
            if (null == stackService) continue;
            stackServiceMap.put(stackService.getName(), stackService);
            Iterator<Object> components = stackService.getComponents();
            Iterator iterator = components.iterator();
            while (iterator.hasNext()) {
                ComponentInfo component = (ComponentInfo)iterator.next();
                stackComponentMap.put(component.getName(), component);
            }
            Set<AlertDefinition> serviceDefinitions = this.getAlertDefinitions(stackService);
            stackDefinitions.addAll(serviceDefinitions);
        }
        ArrayList<AlertDefinitionEntity> persist = new ArrayList<AlertDefinitionEntity>();
        List<AlertDefinitionEntity> entities = this.alertDefinitionDao.findAll(clusterId);
        HashMap<String, AlertDefinitionEntity> mappedEntities = new HashMap<String, AlertDefinitionEntity>(100);
        for (AlertDefinitionEntity entity : entities) {
            mappedEntities.put(entity.getDefinitionName(), entity);
        }
        for (AlertDefinition stackDefinition : stackDefinitions) {
            AlertDefinitionEntity entity = (AlertDefinitionEntity)mappedEntities.get(stackDefinition.getName());
            if (null == entity) {
                entity = this.alertDefinitionFactory.coerce(clusterId, stackDefinition);
                persist.add(entity);
                continue;
            }
            AlertDefinition databaseDefinition = this.alertDefinitionFactory.coerce(entity);
            if (stackDefinition.deeplyEquals(databaseDefinition)) continue;
            if (updateScriptPaths) {
                String newPath;
                Source databaseSource = databaseDefinition.getSource();
                Source stackSource = stackDefinition.getSource();
                if (databaseSource.getType() != SourceType.SCRIPT || stackSource.getType() != SourceType.SCRIPT) continue;
                ScriptSource databaseScript = (ScriptSource)databaseSource;
                ScriptSource stackScript = (ScriptSource)stackSource;
                String oldPath = databaseScript.getPath();
                if (Objects.equals(oldPath, newPath = stackScript.getPath())) continue;
                databaseScript.setPath(newPath);
                entity = this.alertDefinitionFactory.mergeSource(databaseScript, entity);
                persist.add(entity);
                LOG.info("Updating script path for the alert named {} from '{}' to '{}'", new Object[]{stackDefinition.getName(), oldPath, newPath});
                continue;
            }
            LOG.debug("The alert named {} has been modified from the stack definition and will not be merged", (Object)stackDefinition.getName());
        }
        persist.addAll(this.getDefinitionsForMerge(this.ambariServiceAlertDefinitions.getAgentDefinitions(), clusterId, mappedEntities));
        persist.addAll(this.getDefinitionsForMerge(this.ambariServiceAlertDefinitions.getServerDefinitions(), clusterId, mappedEntities));
        for (AlertDefinitionEntity entity : persist) {
            LOG.debug("Merging Alert Definition {} into the database", (Object)entity.getDefinitionName());
            this.alertDefinitionDao.createOrUpdate(entity);
        }
        for (AlertDefinitionEntity def : this.alertDefinitionDao.findAll(cluster.getClusterId())) {
            AlertDefinition realDef = this.alertDefinitionFactory.coerce(def);
            AlertDefinitionRegistrationEvent event = new AlertDefinitionRegistrationEvent(cluster.getClusterId(), realDef);
            this.eventPublisher.publish(event);
        }
        List<AlertDefinitionEntity> definitions = this.alertDefinitionDao.findAllEnabled(clusterId);
        ArrayList<AlertDefinitionEntity> definitionsToDisable = new ArrayList<AlertDefinitionEntity>();
        for (AlertDefinitionEntity definition : definitions) {
            String serviceName = definition.getServiceName();
            String componentName = definition.getComponentName();
            if (RootService.OBDP.name().equals(serviceName)) continue;
            if (!stackServiceMap.containsKey(serviceName)) {
                LOG.info("The {} service has been marked as deleted for cluster {}, disabling alert {}", new Object[]{serviceName, cluster.getClusterName(), definition.getDefinitionName()});
                definitionsToDisable.add(definition);
                continue;
            }
            if (null == componentName || stackComponentMap.containsKey(componentName)) continue;
            StackId stackId = cluster.getService(serviceName).getDesiredStackId();
            LOG.info("The {} component {} has been marked as deleted for stack {}, disabling alert {}", new Object[]{serviceName, componentName, stackId, definition.getDefinitionName()});
            definitionsToDisable.add(definition);
        }
        for (AlertDefinitionEntity definition : definitionsToDisable) {
            definition.setEnabled(false);
            this.alertDefinitionDao.merge(definition);
            this.eventPublisher.publish(new AlertDefinitionDisabledEvent(clusterId, definition.getDefinitionId(), definition.getDefinitionName()));
        }
    }

    public Map<String, UpgradePack> getUpgradePacks(String stackName, String stackVersion) {
        try {
            StackInfo stack = this.getStack(stackName, stackVersion);
            return stack.getUpgradePacks() == null ? Collections.emptyMap() : stack.getUpgradePacks();
        }
        catch (OBDPException e) {
            LOG.debug("Cannot load upgrade packs for non-existent stack {}-{}", new Object[]{stackName, stackVersion, e});
            return Collections.emptyMap();
        }
    }

    public ConfigUpgradePack getConfigUpgradePack(String stackName, String stackVersion) {
        try {
            StackInfo stack = this.getStack(stackName, stackVersion);
            return stack.getConfigUpgradePack();
        }
        catch (OBDPException e) {
            LOG.debug("Cannot load config upgrade pack for non-existent stack {}-{}", new Object[]{stackName, stackVersion, e});
            return null;
        }
    }

    public KerberosDescriptor getKerberosDescriptor(String stackName, String stackVersion, boolean includePreconfigureData) throws OBDPException {
        Map<String, ServiceInfo> services;
        KerberosDescriptor preConfigureKerberosDescriptor;
        StackInfo stackInfo = this.getStack(stackName, stackVersion);
        KerberosDescriptor kerberosDescriptor = this.readKerberosDescriptorFromFile(this.getCommonKerberosDescriptorFileLocation());
        if (kerberosDescriptor == null) {
            LOG.warn("Couldn't read common Kerberos descriptor with path {%s}", (Object)this.getCommonKerberosDescriptorFileLocation());
            kerberosDescriptor = new KerberosDescriptor();
        }
        if (includePreconfigureData && (preConfigureKerberosDescriptor = this.readKerberosDescriptorFromFile(stackInfo.getKerberosDescriptorPreConfigurationFileLocation())) != null) {
            Map<String, KerberosServiceDescriptor> serviceDescriptors = preConfigureKerberosDescriptor.getServices();
            if (serviceDescriptors != null) {
                for (KerberosServiceDescriptor serviceDescriptor : serviceDescriptors.values()) {
                    serviceDescriptor.setPreconfigure(true);
                }
            }
            kerberosDescriptor.update(preConfigureKerberosDescriptor);
        }
        if ((services = this.getServices(stackName, stackVersion)) != null) {
            for (ServiceInfo service : services.values()) {
                KerberosServiceDescriptor[] serviceDescriptors = this.getKerberosDescriptor(service);
                if (serviceDescriptors == null) continue;
                for (KerberosServiceDescriptor serviceDescriptor : serviceDescriptors) {
                    kerberosDescriptor.putService(serviceDescriptor);
                }
            }
        }
        return kerberosDescriptor;
    }

    protected String getCommonKerberosDescriptorFileLocation() {
        return this.commonKerberosDescriptorFileLocation;
    }

    public KerberosServiceDescriptor[] getKerberosDescriptor(ServiceInfo serviceInfo) throws OBDPException {
        File kerberosFile;
        KerberosServiceDescriptor[] kerberosServiceDescriptors = null;
        File file = kerberosFile = serviceInfo == null ? null : serviceInfo.getKerberosDescriptorFile();
        if (kerberosFile != null) {
            try {
                kerberosServiceDescriptors = this.kerberosServiceDescriptorFactory.createInstances(kerberosFile);
            }
            catch (Exception e) {
                LOG.error("Could not read the kerberos descriptor file", (Throwable)e);
                throw new OBDPException("Could not read kerberos descriptor file", (Throwable)e);
            }
        }
        return kerberosServiceDescriptors;
    }

    public Map<String, String> getAmbariServerProperties() {
        return this.conf.getAmbariProperties();
    }

    private synchronized void ensureVersionDefinitions() {
        if (null != this.versionDefinitions && this.versionDefinitions.size() > 0) {
            return;
        }
        this.versionDefinitions = new HashMap<String, VersionDefinitionXml>();
        for (StackInfo stack : this.getStacks()) {
            if (stack.isActive() && stack.isValid()) {
                for (VersionDefinitionXml definition : stack.getVersionDefinitions()) {
                    this.versionDefinitions.put(String.format("%s-%s-%s", stack.getName(), stack.getVersion(), definition.release.version), definition);
                }
                try {
                    VersionDefinitionXml xml = stack.getLatestVersionDefinition();
                    if (null == xml) {
                        xml = VersionDefinitionXml.build(stack);
                    }
                    this.versionDefinitions.put(String.format("%s-%s", stack.getName(), stack.getVersion()), xml);
                }
                catch (Exception e) {
                    LOG.warn("Could not make a stack VDF for {}-{}: {}", new Object[]{stack.getName(), stack.getVersion(), e.getMessage()});
                }
                continue;
            }
            StackId stackId = new StackId(stack);
            if (!stack.isValid()) {
                LOG.info("Stack {} is not valid, skipping VDF: {}", (Object)stackId, (Object)StringUtils.join(stack.getErrors(), (String)"; "));
                continue;
            }
            if (stack.isActive()) continue;
            LOG.info("Stack {} is not active, skipping VDF", (Object)stackId);
        }
    }

    public VersionDefinitionXml getVersionDefinition(String versionDefinitionId) {
        this.ensureVersionDefinitions();
        return this.versionDefinitions.get(versionDefinitionId);
    }

    public Map<String, VersionDefinitionXml> getVersionDefinitions() {
        this.ensureVersionDefinitions();
        return this.versionDefinitions;
    }

    KerberosDescriptor readKerberosDescriptorFromFile(String fileLocation) throws OBDPException {
        if (!StringUtils.isEmpty((String)fileLocation)) {
            File file = new File(fileLocation);
            if (file.canRead()) {
                try {
                    return this.kerberosDescriptorFactory.createInstance(file);
                }
                catch (IOException e) {
                    throw new OBDPException(String.format("Failed to parse Kerberos descriptor file %s", file.getAbsolutePath()), (Throwable)e);
                }
            }
            throw new OBDPException(String.format("Unable to read Kerberos descriptor file %s", file.getAbsolutePath()));
        }
        LOG.debug("Missing path to Kerberos descriptor, returning null");
        return null;
    }

    public File getCommonWidgetsDescriptorFile() {
        return this.commonWidgetsDescriptorFile;
    }

    public void removeMpack(MpackEntity mpackEntity, StackEntity stackEntity) throws IOException {
        boolean stackDelete;
        if (this.versionDefinitions != null) {
            this.versionDefinitions.clear();
        }
        if (stackDelete = this.mpackManager.removeMpack(mpackEntity, stackEntity)) {
            this.stackManager.removeStack(stackEntity);
        }
    }

    public Collection<Mpack> getMpacks() {
        if (this.mpackManager.getMpackMap() != null) {
            return this.mpackManager.getMpackMap().values();
        }
        return Collections.emptySet();
    }

    public Mpack getMpack(Long mpackId) {
        if (this.mpackManager.getMpackMap() != null && this.mpackManager.getMpackMap().containsKey(mpackId)) {
            return this.mpackManager.getMpackMap().get(mpackId);
        }
        return null;
    }
}

