/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import com.google.inject.Inject;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.audit.AuditLogger;
import id.onyx.obdp.server.audit.event.LogoutAuditEvent;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.utils.RequestUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.springframework.security.core.context.SecurityContextHolder;

@StaticallyInject
@Path(value="/logout")
public class LogoutService {
    @Inject
    private static AuditLogger auditLogger;

    @GET
    @Produces(value={"text/plain"})
    public Response performLogout(@Context HttpServletRequest servletRequest) {
        this.auditLog(servletRequest);
        SecurityContextHolder.clearContext();
        servletRequest.getSession().invalidate();
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private void auditLog(HttpServletRequest servletRequest) {
        if (!auditLogger.isEnabled()) {
            return;
        }
        LogoutAuditEvent logoutEvent = (LogoutAuditEvent)((LogoutAuditEvent.LogoutAuditEventBuilder)((LogoutAuditEvent.LogoutAuditEventBuilder)((LogoutAuditEvent.LogoutAuditEventBuilder)((LogoutAuditEvent.LogoutAuditEventBuilder)LogoutAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRemoteIp(RequestUtils.getRemoteAddress(servletRequest))).withUserName(AuthorizationHelper.getAuthenticatedName())).withProxyUserName(AuthorizationHelper.getProxyUserName())).build();
        auditLogger.log(logoutEvent);
    }
}

