/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.api.services.serializers.ResultSerializer;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.logging.LogQueryResponse;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelper;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelperFactory;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.utils.RetryHelper;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingService.class);
    private static final Set<RoleAuthorization> REQUIRED_AUTHORIZATIONS = EnumSet.of(RoleAuthorization.SERVICE_VIEW_OPERATIONAL_LOGS);
    private final ControllerFactory controllerFactory;
    @Inject
    private LoggingRequestHelperFactory helperFactory;
    private final String clusterName;

    public LoggingService(String clusterName) {
        this(clusterName, new DefaultControllerFactory());
    }

    public LoggingService(String clusterName, ControllerFactory controllerFactory) {
        this.clusterName = clusterName;
        this.controllerFactory = controllerFactory;
    }

    @GET
    @Path(value="searchEngine")
    @Produces(value={"text/plain"})
    public Response getSearchEngine(String body, @Context HttpHeaders headers, @Context UriInfo uri) throws AuthorizationException {
        if (AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, this.getClusterResourceId(), REQUIRED_AUTHORIZATIONS)) {
            return this.handleDirectRequest(uri, MediaType.TEXT_PLAIN_TYPE);
        }
        Response.ResponseBuilder responseBuilder = Response.status((int)new ResultStatus(ResultStatus.STATUS.FORBIDDEN).getStatusCode());
        responseBuilder.entity((Object)"The authenticated user is not authorized to perform this operation.");
        return responseBuilder.build();
    }

    private Long getClusterResourceId() {
        Long clusterResourceId;
        block5: {
            clusterResourceId = null;
            if (!StringUtils.isEmpty((String)this.clusterName)) {
                try {
                    Cluster cluster = this.controllerFactory.getController().getClusters().getCluster(this.clusterName);
                    if (cluster == null) {
                        LOG.warn("No cluster found with the name {}, assuming null resource id", (Object)this.clusterName);
                        break block5;
                    }
                    clusterResourceId = cluster.getResourceId();
                }
                catch (OBDPException e) {
                    LOG.warn("An exception occurred looking up the cluster named {}, assuming null resource id: {}", (Object)this.clusterName, (Object)e.getLocalizedMessage());
                }
            } else {
                LOG.debug("The cluster name is not set, assuming null resource id");
            }
        }
        return clusterResourceId;
    }

    protected Response handleDirectRequest(UriInfo uriInfo, MediaType mediaType) {
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        HashMap<String, String> enumeratedQueryParameters = new HashMap<String, String>();
        for (String queryName : queryParameters.keySet()) {
            List queryValue = (List)queryParameters.get((Object)queryName);
            for (String value : queryValue) {
                enumeratedQueryParameters.put(queryName, value);
            }
        }
        OBDPManagementController controller = this.controllerFactory.getController();
        LoggingRequestHelper requestHelper = this.helperFactory.getHelper(controller, this.clusterName);
        if (requestHelper != null) {
            LogQueryResponse response = requestHelper.sendQueryRequest(enumeratedQueryParameters);
            if (response != null) {
                ResultSerializer serializer = mediaType == null ? this.getResultSerializer() : this.getResultSerializer(mediaType);
                ResultImpl result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.OK));
                ResourceImpl loggingResource = new ResourceImpl(Resource.Type.LoggingQuery);
                loggingResource.setProperty("startIndex", response.getStartIndex());
                loggingResource.setProperty("pageSize", response.getPageSize());
                loggingResource.setProperty("resultSize", response.getResultSize());
                loggingResource.setProperty("queryTimeMMS", response.getQueryTimeMS());
                loggingResource.setProperty("totalCount", response.getTotalCount());
                loggingResource.setProperty("logList", response.getListOfResults());
                result.getResultTree().addChild(loggingResource, "logging");
                Response.ResponseBuilder builder = Response.status((int)result.getStatus().getStatusCode()).entity(serializer.serialize(result));
                if (mediaType != null) {
                    builder.type(mediaType);
                }
                RetryHelper.clearAffectedClusters();
                return builder.build();
            }
        } else {
            LOG.debug("LogSearch is not currently available, an empty response will be returned");
        }
        Response.ResponseBuilder responseBuilder = Response.status((int)new ResultStatus(ResultStatus.STATUS.NOT_FOUND).getStatusCode());
        responseBuilder.entity((Object)"LogSearch is not currently available.  If LogSearch is deployed in this cluster, please verify that the LogSearch services are running.");
        return responseBuilder.build();
    }

    void setLoggingRequestHelperFactory(LoggingRequestHelperFactory helperFactory) {
        this.helperFactory = helperFactory;
    }

    private static class DefaultControllerFactory
    implements ControllerFactory {
        private DefaultControllerFactory() {
        }

        @Override
        public OBDPManagementController getController() {
            return OBDPServer.getController();
        }
    }

    static interface ControllerFactory {
        public OBDPManagementController getController();
    }
}

