/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/ldap_sync_events/")
public class LdapSyncEventService
extends BaseService {
    @GET
    @Path(value="{eventId}")
    @Produces(value={"text/plain"})
    public Response getEvent(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="eventId") String eventId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createEventResource(eventId));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getEvents(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createEventResource(null));
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createEvent(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createEventResource(null));
    }

    @PUT
    @Path(value="{eventId}")
    @Produces(value={"text/plain"})
    public Response updateEvent(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="eventId") String eventId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createEventResource(eventId));
    }

    @DELETE
    @Path(value="{eventId}")
    @Produces(value={"text/plain"})
    public Response deleteEvent(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="eventId") String eventId) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createEventResource(eventId));
    }

    private ResourceInstance createEventResource(String eventId) {
        return this.createResource(Resource.Type.LdapSyncEvent, Collections.singletonMap(Resource.Type.LdapSyncEvent, eventId));
    }
}

