/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import com.google.inject.Inject;
import id.onyx.obdp.server.api.services.PersistKeyValueImpl;
import id.onyx.obdp.server.utils.StageUtils;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.util.Collection;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/keys/")
public class KeyService {
    private static final Logger log = LoggerFactory.getLogger(KeyService.class);
    private static PersistKeyValueImpl persistKeyVal;

    @Inject
    public static void init(PersistKeyValueImpl instance) {
        persistKeyVal = instance;
    }

    @Path(value="{number}")
    @GET
    @Produces(value={"text/plain"})
    public String getKeys(@PathParam(value="number") int number) throws IOException, JAXBException {
        Collection<String> keys = persistKeyVal.generateKeys(number);
        String result = StageUtils.jaxbToString(keys);
        log.info("Returning keys {}", (Object)result);
        return result;
    }
}

