/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/kerberos_descriptors/")
public class KerberosDescriptorService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    public Response getKerberosDescriptors(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createKerberosDescriptorResource(null));
    }

    @GET
    @Path(value="{kerberosDescriptorName}")
    @Produces(value={"text/plain"})
    public Response getKerberosDescriptor(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="kerberosDescriptorName") String kerberosDescriptorName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createKerberosDescriptorResource(kerberosDescriptorName));
    }

    @POST
    @Path(value="{kerberosDescriptorName}")
    @Produces(value={"text/plain"})
    public Response createKerberosDescriptor(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="kerberosDescriptorName") String kerberosDescriptorName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createKerberosDescriptorResource(kerberosDescriptorName));
    }

    @DELETE
    @Path(value="{kerberosDescriptorName}")
    @Produces(value={"text/plain"})
    public Response deleteKerberosDescriptor(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="kerberosDescriptorName") String kerberosDescriptorName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createKerberosDescriptorResource(kerberosDescriptorName));
    }

    private ResourceInstance createKerberosDescriptorResource(String kerberosDescriptorName) {
        return this.createResource(Resource.Type.KerberosDescriptor, Collections.singletonMap(Resource.Type.KerberosDescriptor, kerberosDescriptorName));
    }
}

