/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.TaskAttemptService;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class JobService
extends BaseService {
    private String workflowId;
    private String clusterName;

    public JobService(String clusterName, String workflowId) {
        this.clusterName = clusterName;
        this.workflowId = workflowId;
    }

    @GET
    @Path(value="{jobId}")
    @Produces(value={"text/plain"})
    public Response getJob(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="jobId") String jobId) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createJobResource(this.clusterName, this.workflowId, jobId));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getJobs(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createJobResource(this.clusterName, this.workflowId, null));
    }

    @Path(value="{jobId}/taskattempts")
    public TaskAttemptService getTaskAttemptHandler(@PathParam(value="jobId") String jobId) {
        return new TaskAttemptService(this.clusterName, this.workflowId, jobId);
    }

    ResourceInstance createJobResource(String clusterName, String workflowId, String jobId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Workflow, workflowId);
        mapIds.put(Resource.Type.Job, jobId);
        return this.createResource(Resource.Type.Job, mapIds);
    }
}

