/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/instances/")
public class InstanceService
extends BaseService {
    private String m_feedName;

    public InstanceService() {
    }

    public InstanceService(String feedName) {
        this.m_feedName = feedName;
    }

    @GET
    @Path(value="{instanceID}")
    @Produces(value={"text/plain"})
    public Response getInstance(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="instanceID") String instanceID) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createInstanceResource(this.m_feedName, instanceID, ui));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getInstances(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createInstanceResource(this.m_feedName, null, ui));
    }

    @POST
    @Path(value="{instanceID}")
    @Produces(value={"text/plain"})
    public Response createInstance(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="instanceID") String instanceID) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createInstanceResource(this.m_feedName, instanceID, ui));
    }

    @PUT
    @Path(value="{instanceID}")
    @Produces(value={"text/plain"})
    public Response updateInstance(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="instanceID") String instanceID) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createInstanceResource(this.m_feedName, instanceID, ui));
    }

    @DELETE
    @Path(value="{instanceID}")
    @Produces(value={"text/plain"})
    public Response deleteInstance(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="instanceID") String instanceID) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createInstanceResource(this.m_feedName, instanceID, ui));
    }

    ResourceInstance createInstanceResource(String feedName, String instanceID, UriInfo ui) {
        boolean isAttached = ui.getRequestUri().toString().contains("/feeds/");
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.DRInstance, instanceID);
        if (isAttached) {
            mapIds.put(Resource.Type.DRFeed, feedName);
        }
        return this.createResource(Resource.Type.DRInstance, mapIds);
    }
}

