/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.RepositoryVersionService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class HostStackVersionService
extends BaseService {
    private String hostName;
    private String clusterName;

    public HostStackVersionService(String hostName, String clusterName) {
        this.hostName = hostName;
        this.clusterName = clusterName;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getHostStackVersions(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(ui, this.clusterName, this.hostName, null));
    }

    @GET
    @Path(value="{stackVersionId}")
    @Produces(value={"text/plain"})
    public Response getHostStackVersion(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="stackVersionId") String stackVersionId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(ui, this.clusterName, this.hostName, stackVersionId));
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createRequests(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(ui, this.clusterName, this.hostName, null));
    }

    @Path(value="{stackVersionId}/repository_versions")
    public RepositoryVersionService getRepositoryVersionHandler(@PathParam(value="stackVersionId") String stackVersionId) {
        HashMap<Resource.Type, String> stackVersionProperties = new HashMap<Resource.Type, String>();
        stackVersionProperties.put(Resource.Type.Host, this.hostName);
        stackVersionProperties.put(Resource.Type.HostStackVersion, stackVersionId);
        return new RepositoryVersionService(stackVersionProperties);
    }

    private ResourceInstance createResource(UriInfo ui, String clusterName, String hostName, String stackVersionId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        if (clusterName != null) {
            mapIds.put(Resource.Type.Cluster, clusterName);
        }
        mapIds.put(Resource.Type.Host, hostName);
        mapIds.put(Resource.Type.HostStackVersion, stackVersionId);
        return this.createResource(Resource.Type.HostStackVersion, mapIds);
    }
}

