/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.AlertHistoryService;
import id.onyx.obdp.server.api.services.AlertService;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.HostComponentService;
import id.onyx.obdp.server.api.services.HostKerberosIdentityService;
import id.onyx.obdp.server.api.services.HostStackVersionService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.HostResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/hosts")
@Api(value="Hosts", description="Endpoint for host-specific operations")
public class HostService
extends BaseService {
    private static final String UNKNOWN_HOSTS = "Attempt to add hosts that have not been registered";
    private static final String HOST_ALREADY_EXISTS = "Attempt to create a host which already exists";
    private static final String HOST_REQUEST_TYPE = "id.onyx.obdp.server.controller.HostRequest";
    private final String m_clusterName;

    public HostService() {
        this(null);
    }

    public HostService(String clusterName) {
        this.m_clusterName = clusterName;
    }

    @GET
    @Path(value="{hostName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns information about a single host", response=HostResponse.HostResponseWrapper.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getHost(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="host name", required=true) @PathParam(value="hostName") String hostName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createHostResource(this.m_clusterName, hostName));
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns a collection of all hosts", response=HostResponse.HostResponseWrapper.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Hosts/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", defaultValue="Hosts/host_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getHosts(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createHostResource(this.m_clusterName, null));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates multiple hosts in a single request")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.HostRequest", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Attempt to add hosts that have not been registered"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=409, message="Attempt to create a host which already exists"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createHosts(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createHostResource(this.m_clusterName, null));
    }

    @POST
    @Path(value="{hostName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates a host")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.HostRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=409, message="Attempt to create a host which already exists"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createHost(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="host name", required=true) @PathParam(value="hostName") String hostName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createHostResource(this.m_clusterName, hostName));
    }

    @PUT
    @Path(value="{hostName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates a host")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.HostRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateHost(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="host name", required=true) @PathParam(value="hostName") String hostName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createHostResource(this.m_clusterName, hostName));
    }

    @PUT
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates multiple hosts in a single request")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.HostRequest", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateHosts(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createHostResource(this.m_clusterName, null));
    }

    @DELETE
    @Path(value="{hostName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes a host")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteHost(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="host name", required=true) @PathParam(value="hostName") String hostName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createHostResource(this.m_clusterName, hostName));
    }

    @DELETE
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes multiple hosts in a single request")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.HostRequest", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteHosts(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createHostResource(this.m_clusterName, null));
    }

    @Path(value="{hostName}/host_components")
    public HostComponentService getHostComponentHandler(@PathParam(value="hostName") String hostName) {
        return new HostComponentService(this.m_clusterName, hostName);
    }

    @Path(value="{hostName}/kerberos_identities")
    public HostKerberosIdentityService getHostKerberosIdentityHandler(@PathParam(value="hostName") String hostName) {
        return new HostKerberosIdentityService(this.m_clusterName, hostName);
    }

    @Path(value="{hostName}/alerts")
    public AlertService getAlertHandler(@PathParam(value="hostName") String hostName) {
        return new AlertService(this.m_clusterName, null, hostName);
    }

    @Path(value="{hostName}/alert_history")
    public AlertHistoryService getAlertHistoryService(@Context Request request, @PathParam(value="hostName") String hostName) {
        return new AlertHistoryService(this.m_clusterName, null, hostName);
    }

    @Path(value="{hostName}/stack_versions")
    public HostStackVersionService getHostStackVersionService(@Context Request request, @PathParam(value="hostName") String hostName) {
        return new HostStackVersionService(hostName, this.m_clusterName);
    }

    protected ResourceInstance createHostResource(String clusterName, String hostName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Host, hostName);
        if (clusterName != null) {
            mapIds.put(Resource.Type.Cluster, clusterName);
        }
        return this.createResource(Resource.Type.Host, mapIds);
    }
}

