/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class HostKerberosIdentityService
extends BaseService {
    private String clusterName;
    private String hostName;

    public HostKerberosIdentityService(String clusterName, String hostName) {
        this.clusterName = clusterName;
        this.hostName = hostName;
    }

    @GET
    @Path(value="{kerberosIdentityID}")
    @Produces(value={"text/plain"})
    public Response getKerberosIdentity(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="kerberosIdentityID") String identityID, @QueryParam(value="format") String format) {
        Object mediaType = "csv".equalsIgnoreCase(format) ? MEDIA_TYPE_TEXT_CSV_TYPE : null;
        return this.handleRequest(headers, body, ui, Request.Type.GET, (MediaType)mediaType, this.createResource(this.clusterName, this.hostName, identityID));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getKerberosIdentities(String body, @Context HttpHeaders headers, @Context UriInfo ui, @QueryParam(value="format") String format) {
        return this.getKerberosIdentity(body, headers, ui, null, format);
    }

    ResourceInstance createResource(String clusterName, String hostName, String identityId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Host, hostName);
        mapIds.put(Resource.Type.HostKerberosIdentity, identityId);
        return this.createResource(Resource.Type.HostKerberosIdentity, mapIds);
    }
}

