/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.annotations.SwaggerPreferredParent;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.ClusterService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.HostComponentProcessResponse;
import id.onyx.obdp.server.controller.HostComponentSwagger;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

@Api(value="Host Components", description="Endpoint for host component specific operations")
@SwaggerPreferredParent(preferredParent=ClusterService.class)
public class HostComponentService
extends BaseService {
    public static final String HOST_ROLE_REQUEST_TYPE = "id.onyx.obdp.server.controller.ServiceComponentHostResponse";
    private String m_clusterName;
    private String m_hostName;

    public HostComponentService(String clusterName, String hostName) {
        this.m_clusterName = clusterName;
        this.m_hostName = hostName;
    }

    @GET
    @Path(value="{hostComponentName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get single host component for a host", response=HostComponentSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getHostComponent(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="hostComponentName") String hostComponentName, @QueryParam(value="format") String format) {
        if (this.m_hostName == null) {
            String s = "Invalid request. Must provide host information when requesting a host_resource instance resource.";
            return Response.status((int)400).entity((Object)s).build();
        }
        if (format != null && format.equals("client_config_tar")) {
            return this.createClientConfigResource(body, headers, ui, hostComponentName);
        }
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createHostComponentResource(this.m_clusterName, this.m_hostName, hostComponentName));
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all host components for a host", response=HostComponentSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getHostComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui, @QueryParam(value="format") String format) {
        if (format != null && format.equals("client_config_tar")) {
            return this.createClientConfigResource(body, headers, ui, null);
        }
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createHostComponentResource(this.m_clusterName, this.m_hostName, null));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create new host components")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ServiceComponentHostResponse", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createHostComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createHostComponentResource(this.m_clusterName, this.m_hostName, null));
    }

    @POST
    @Path(value="{hostComponentName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create new host component")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ServiceComponentHostResponse", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createHostComponent(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="hostComponentName") String hostComponentName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createHostComponentResource(this.m_clusterName, this.m_hostName, hostComponentName));
    }

    @PUT
    @Path(value="{hostComponentName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Update host component detail")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ServiceComponentHostResponse", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateHostComponent(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="hostComponentName") String hostComponentName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createHostComponentResource(this.m_clusterName, this.m_hostName, hostComponentName));
    }

    @PUT
    @Produces(value={"text/plain"})
    @ApiOperation(value="Update multiple host component details")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ServiceComponentHostResponse", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateHostComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createHostComponentResource(this.m_clusterName, this.m_hostName, null));
    }

    @DELETE
    @Path(value="{hostComponentName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete host component")
    @ApiImplicitParams(value={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteHostComponent(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="hostComponentName") String hostComponentName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createHostComponentResource(this.m_clusterName, this.m_hostName, hostComponentName));
    }

    @DELETE
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete host components")
    @ApiImplicitParams(value={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteHostComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createHostComponentResource(this.m_clusterName, this.m_hostName, null));
    }

    @GET
    @Path(value="{hostComponentName}/processes")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get processes of a specific host component", response=HostComponentProcessResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getProcesses(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="hostComponentName") String hostComponentName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.m_clusterName);
        mapIds.put(Resource.Type.Host, this.m_hostName);
        mapIds.put(Resource.Type.HostComponent, hostComponentName);
        ResourceInstance ri = this.createResource(Resource.Type.HostComponentProcess, mapIds);
        return this.handleRequest(headers, null, ui, Request.Type.GET, ri);
    }

    ResourceInstance createHostComponentResource(String clusterName, String hostName, String hostComponentName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Host, hostName);
        mapIds.put(Resource.Type.HostComponent, hostComponentName);
        return this.createResource(Resource.Type.HostComponent, mapIds);
    }

    private Response createClientConfigResource(String body, HttpHeaders headers, UriInfo ui, String hostComponentName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.m_clusterName);
        mapIds.put(Resource.Type.Host, this.m_hostName);
        mapIds.put(Resource.Type.Component, hostComponentName);
        Response response = this.handleRequest(headers, body, ui, Request.Type.GET, this.createResource(Resource.Type.ClientConfig, mapIds));
        if (response.getStatus() != 200) {
            return response;
        }
        Object filePrefixName = StringUtils.isEmpty((String)hostComponentName) ? this.m_hostName + "(" + Resource.InternalType.Host.toString().toUpperCase() + ")" : hostComponentName;
        Validate.notNull((Object)filePrefixName, (String)"compressed config file name should not be null");
        String fileName = (String)filePrefixName + "-configs" + Configuration.DEF_ARCHIVE_EXTENSION;
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.OK);
        Configuration configs = new Configuration();
        String tmpDir = configs.getProperty(Configuration.SERVER_TMP_DIR.getKey());
        File file = new File(tmpDir, fileName);
        FileInputStream resultInputStream = null;
        try {
            resultInputStream = new FileInputStream(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String contentType = Configuration.DEF_ARCHIVE_CONTENT_TYPE;
        rb.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\""));
        rb.entity((Object)resultInputStream);
        return rb.type(contentType).build();
    }
}

