/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.InstanceService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/feeds/")
public class FeedService
extends BaseService {
    @GET
    @Path(value="{feedName}")
    @Produces(value={"text/plain"})
    public Response getFeed(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="feedName") String feedName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createFeedResource(feedName));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getFeeds(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createFeedResource(null));
    }

    @POST
    @Path(value="{feedName}")
    @Produces(value={"text/plain"})
    public Response createFeed(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="feedName") String feedName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createFeedResource(feedName));
    }

    @PUT
    @Path(value="{feedName}")
    @Produces(value={"text/plain"})
    public Response updateFeed(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="feedName") String feedName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createFeedResource(feedName));
    }

    @DELETE
    @Path(value="{feedName}")
    @Produces(value={"text/plain"})
    public Response deleteFeed(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="feedName") String feedName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createFeedResource(feedName));
    }

    @Path(value="{feedName}/instances")
    public InstanceService getHostHandler(@PathParam(value="feedName") String feedName) {
        return new InstanceService(feedName);
    }

    ResourceInstance createFeedResource(String feedName) {
        return this.createResource(Resource.Type.DRFeed, Collections.singletonMap(Resource.Type.DRFeed, feedName));
    }
}

