/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.HashMap;

@Path(value="/extensions/")
public class ExtensionsService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    public Response getExtensions(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createExtensionResource(null));
    }

    @GET
    @Path(value="{extensionName}")
    @Produces(value={"text/plain"})
    public Response getExtension(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="extensionName") String extensionName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createExtensionResource(extensionName));
    }

    @GET
    @Path(value="{extensionName}/versions")
    @Produces(value={"text/plain"})
    public Response getExtensionVersions(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="extensionName") String extensionName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createExtensionVersionResource(extensionName, null));
    }

    @GET
    @Path(value="{extensionName}/versions/{extensionVersion}")
    @Produces(value={"text/plain"})
    public Response getExtensionVersion(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="extensionName") String extensionName, @PathParam(value="extensionVersion") String extensionVersion) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createExtensionVersionResource(extensionName, extensionVersion));
    }

    @GET
    @Path(value="{extensionName}/versions/{extensionVersion}/links")
    @Produces(value={"text/plain"})
    public Response getExtensionVersionLinks(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="extensionName") String extensionName, @PathParam(value="extensionVersion") String extensionVersion) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createExtensionLinkResource(null, null, extensionName, extensionVersion));
    }

    ResourceInstance createExtensionVersionResource(String extensionName, String extensionVersion) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Extension, extensionName);
        mapIds.put(Resource.Type.ExtensionVersion, extensionVersion);
        return this.createResource(Resource.Type.ExtensionVersion, mapIds);
    }

    ResourceInstance createExtensionLinkResource(String stackName, String stackVersion, String extensionName, String extensionVersion) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.Extension, extensionName);
        mapIds.put(Resource.Type.ExtensionVersion, extensionVersion);
        return this.createResource(Resource.Type.ExtensionLink, mapIds);
    }

    ResourceInstance createExtensionResource(String extensionName) {
        return this.createResource(Resource.Type.Extension, Collections.singletonMap(Resource.Type.Extension, extensionName));
    }
}

