/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/links/")
public class ExtensionLinksService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    public Response getExtensionLinks(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createExtensionLinkResource(null));
    }

    @GET
    @Path(value="{linkId}")
    @Produces(value={"text/plain"})
    public Response getExtensionLink(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="linkId") String linkId) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createExtensionLinkResource(linkId));
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createExtensionLink(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createExtensionLinkResource(null));
    }

    @DELETE
    @Path(value="{linkId}")
    @Produces(value={"text/plain"})
    public Response deleteExtensionLink(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="linkId") String linkId) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createExtensionLinkResource(linkId));
    }

    @PUT
    @Produces(value={"text/plain"})
    public Response updateExtensionLink(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createExtensionLinkResource(null));
    }

    @PUT
    @Path(value="{linkId}")
    @Produces(value={"text/plain"})
    public Response updateExtensionLink(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="linkId") String linkId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createExtensionLinkResource(linkId));
    }

    ResourceInstance createExtensionLinkResource(String linkId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.ExtensionLink, linkId);
        return this.createResource(Resource.Type.ExtensionLink, mapIds);
    }
}

