/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.api.services.ResultMetadata;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class DeleteResultMetadata
implements ResultMetadata {
    private final Set<String> deletedKeys = new HashSet<String>();
    private final Map<String, ResultStatus> excptions = new HashMap<String, ResultStatus>();

    public void addDeletedKey(String key) {
        Validate.notNull((Object)key);
        this.deletedKeys.add(key);
    }

    public void addDeletedKeys(Collection<String> keys) {
        Validate.notNull(keys);
        this.deletedKeys.addAll(keys);
    }

    public void addException(String key, Exception ex) {
        Validate.notNull((Object)key);
        Validate.notNull((Object)ex);
        ResultStatus resultStatus = this.getResultStatusForException(ex);
        this.excptions.put(key, resultStatus);
    }

    public void addExceptions(Map<String, Exception> exceptionKeyMap) {
        if (exceptionKeyMap == null) {
            return;
        }
        for (Map.Entry<String, Exception> exceptionEntry : exceptionKeyMap.entrySet()) {
            ResultStatus resultStatus = this.getResultStatusForException(exceptionEntry.getValue());
            this.excptions.put(exceptionEntry.getKey(), resultStatus);
        }
    }

    public Set<String> getDeletedKeys() {
        return Collections.unmodifiableSet(this.deletedKeys);
    }

    public Map<String, ResultStatus> getExcptions() {
        return Collections.unmodifiableMap(this.excptions);
    }

    private ResultStatus getResultStatusForException(Exception ex) {
        Validate.notNull((Object)ex);
        if (ex.getClass() == AuthorizationException.class) {
            return new ResultStatus(ResultStatus.STATUS.FORBIDDEN, ex);
        }
        if (ex.getClass() == SystemException.class) {
            return new ResultStatus(ResultStatus.STATUS.SERVER_ERROR, ex);
        }
        if (ex instanceof ObjectNotFoundException) {
            return new ResultStatus(ResultStatus.STATUS.NOT_FOUND, ex);
        }
        if (ex.getClass() == UnsupportedPropertyException.class) {
            return new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, ex);
        }
        return new ResultStatus(ResultStatus.STATUS.SERVER_ERROR, ex);
    }
}

