/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class CredentialService
extends BaseService {
    private final String clusterName;

    public CredentialService(String clusterName) {
        this.clusterName = clusterName;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getCredentials(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createCredentialResource(null));
    }

    @GET
    @Path(value="{alias}")
    @Produces(value={"text/plain"})
    public Response getCredential(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="alias") String alias) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createCredentialResource(alias));
    }

    @POST
    @Path(value="{alias}")
    @Produces(value={"text/plain"})
    public Response createCredential(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="alias") String alias) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createCredentialResource(alias));
    }

    @PUT
    @Path(value="{alias}")
    @Produces(value={"text/plain"})
    public Response updateCredential(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="alias") String alias) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createCredentialResource(alias));
    }

    @DELETE
    @Path(value="{alias}")
    @Produces(value={"text/plain"})
    public Response deleteCredential(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="alias") String alias) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createCredentialResource(alias));
    }

    ResourceInstance createCredentialResource(String alias) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.clusterName);
        mapIds.put(Resource.Type.Credential, alias);
        return this.createResource(Resource.Type.Credential, mapIds);
    }
}

