/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.ConfigGroupResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Api(value="Config Groups", description="Endpoint for config-group-specific operations")
public class ConfigGroupService
extends BaseService {
    private static final String CONFIG_GROUP_REQUEST_TYPE = "id.onyx.obdp.server.controller.ConfigGroupRequest";
    private String m_clusterName;

    public ConfigGroupService(String m_clusterName) {
        this.m_clusterName = m_clusterName;
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns all config groups", response=ConfigGroupResponse.ConfigGroupWrapper.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="ConfigGroup/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getConfigGroups(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createConfigGroupResource(this.m_clusterName, null));
    }

    @GET
    @Path(value="{groupId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns a single config group", response=ConfigGroupResponse.ConfigGroupWrapper.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="ConfigGroup/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getConfigGroup(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="groupId") String groupId) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createConfigGroupResource(this.m_clusterName, groupId));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates a config group")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ConfigGroupRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=500, message="Internal server error")})
    public Response createConfigGroup(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createConfigGroupResource(this.m_clusterName, null));
    }

    @PUT
    @Path(value="{groupId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates a config group")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ConfigGroupRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateConfigGroup(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="groupId") String groupId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createConfigGroupResource(this.m_clusterName, groupId));
    }

    @DELETE
    @Path(value="{groupId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes a config group")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteConfigGroup(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="groupId") String groupId) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createConfigGroupResource(this.m_clusterName, groupId));
    }

    ResourceInstance createConfigGroupResource(String clusterName, String groupId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.ConfigGroup, groupId);
        return this.createResource(Resource.Type.ConfigGroup, mapIds);
    }
}

