/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ComponentService
extends BaseService {
    private String m_clusterName;
    private String m_serviceName;

    public ComponentService(String clusterName, String serviceName) {
        this.m_clusterName = clusterName;
        this.m_serviceName = serviceName;
    }

    @GET
    @Path(value="{componentName}")
    @Produces(value={"text/plain"})
    public Response getComponent(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="componentName") String componentName, @QueryParam(value="format") String format) {
        if (format != null && format.equals("client_config_tar")) {
            return this.createClientConfigResource(body, headers, ui, componentName);
        }
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createComponentResource(this.m_clusterName, this.m_serviceName, componentName));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui, @QueryParam(value="format") String format) {
        if (format != null && format.equals("client_config_tar")) {
            return this.createClientConfigResource(body, headers, ui, null);
        }
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createComponentResource(this.m_clusterName, this.m_serviceName, null));
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createComponentResource(this.m_clusterName, this.m_serviceName, null));
    }

    @POST
    @Path(value="{componentName}")
    @Produces(value={"text/plain"})
    public Response createComponent(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="componentName") String componentName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createComponentResource(this.m_clusterName, this.m_serviceName, componentName));
    }

    @PUT
    @Path(value="{componentName}")
    @Produces(value={"text/plain"})
    public Response updateComponent(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="componentName") String componentName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createComponentResource(this.m_clusterName, this.m_serviceName, componentName));
    }

    @PUT
    @Produces(value={"text/plain"})
    public Response updateComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createComponentResource(this.m_clusterName, this.m_serviceName, null));
    }

    @DELETE
    @Path(value="{componentName}")
    @Produces(value={"text/plain"})
    public Response deleteComponent(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="componentName") String componentName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createComponentResource(this.m_clusterName, this.m_serviceName, componentName));
    }

    ResourceInstance createComponentResource(String clusterName, String serviceName, String componentName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Service, serviceName);
        mapIds.put(Resource.Type.Component, componentName);
        return this.createResource(Resource.Type.Component, mapIds);
    }

    private Response createClientConfigResource(String body, HttpHeaders headers, UriInfo ui, String componentName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.m_clusterName);
        mapIds.put(Resource.Type.Service, this.m_serviceName);
        mapIds.put(Resource.Type.Component, componentName);
        Object filePrefixName = StringUtils.isEmpty((String)componentName) ? (StringUtils.isEmpty((String)this.m_serviceName) ? this.m_clusterName + "(" + Resource.InternalType.Cluster.toString().toUpperCase() + ")" : this.m_serviceName + "(" + Resource.InternalType.Service.toString().toUpperCase() + ")") : componentName;
        Validate.notNull((Object)filePrefixName, (String)"compressed config file name should not be null");
        String fileName = (String)filePrefixName + "-configs" + Configuration.DEF_ARCHIVE_EXTENSION;
        Response response = this.handleRequest(headers, body, ui, Request.Type.GET, this.createResource(Resource.Type.ClientConfig, mapIds));
        if (response.getStatus() != 200) {
            return response;
        }
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.OK);
        Configuration configs = new Configuration();
        String tmpDir = configs.getProperty(Configuration.SERVER_TMP_DIR.getKey());
        File file = new File(tmpDir, fileName);
        FileInputStream resultInputStream = null;
        try {
            resultInputStream = new FileInputStream(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String contentType = Configuration.DEF_ARCHIVE_CONTENT_TYPE;
        rb.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\""));
        rb.entity((Object)resultInputStream);
        return rb.type(contentType).build();
    }
}

