/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.OperatingSystemService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;

public class CompatibleRepositoryVersionService
extends BaseService {
    private Map<Resource.Type, String> parentKeyProperties;

    public CompatibleRepositoryVersionService(Map<Resource.Type, String> parentProperties) {
        this.parentKeyProperties = parentProperties;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getRepositoryVersions(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(null));
    }

    @GET
    @Path(value="{repositoryVersionId}")
    @Produces(value={"text/plain"})
    public Response getRepositoryVersion(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="repositoryVersionId") String repositoryVersionId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(repositoryVersionId));
    }

    @Path(value="{repositoryVersionId}/operating_systems")
    public OperatingSystemService getOperatingSystemsHandler(@PathParam(value="repositoryVersionId") String repositoryVersionId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.putAll(this.parentKeyProperties);
        mapIds.put(Resource.Type.CompatibleRepositoryVersion, repositoryVersionId);
        return new OperatingSystemService(mapIds);
    }

    private ResourceInstance createResource(String repositoryVersionId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.putAll(this.parentKeyProperties);
        mapIds.put(Resource.Type.CompatibleRepositoryVersion, repositoryVersionId);
        return this.createResource(Resource.Type.CompatibleRepositoryVersion, mapIds);
    }
}

