/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.RepositoryVersionService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class ClusterStackVersionService
extends BaseService {
    private String clusterName;

    public ClusterStackVersionService(String clusterName) {
        this.clusterName = clusterName;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getClusterStackVersions(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(null));
    }

    @GET
    @Path(value="{stackVersionId}")
    @Produces(value={"text/plain"})
    public Response getClusterStackVersion(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="stackVersionId") String stackVersionId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(stackVersionId));
    }

    @Path(value="{stackVersionId}/repository_versions")
    public RepositoryVersionService getRepositoryVersionService(@Context Request request, @PathParam(value="stackVersionId") String stackVersion) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.clusterName);
        mapIds.put(Resource.Type.ClusterStackVersion, stackVersion);
        return new RepositoryVersionService(mapIds);
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createRequests(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(null));
    }

    @PUT
    @Produces(value={"text/plain"})
    public Response updateRequests(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResource(null));
    }

    private ResourceInstance createResource(String stackVersionId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.clusterName);
        mapIds.put(Resource.Type.ClusterStackVersion, stackVersionId);
        return this.createResource(Resource.Type.ClusterStackVersion, mapIds);
    }
}

