/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.AlertDefinitionService;
import id.onyx.obdp.server.api.services.AlertGroupService;
import id.onyx.obdp.server.api.services.AlertHistoryService;
import id.onyx.obdp.server.api.services.AlertNoticeService;
import id.onyx.obdp.server.api.services.AlertService;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.ClusterKerberosDescriptorService;
import id.onyx.obdp.server.api.services.ClusterPrivilegeService;
import id.onyx.obdp.server.api.services.ClusterStackVersionService;
import id.onyx.obdp.server.api.services.ComponentService;
import id.onyx.obdp.server.api.services.ConfigGroupService;
import id.onyx.obdp.server.api.services.ConfigurationService;
import id.onyx.obdp.server.api.services.CredentialService;
import id.onyx.obdp.server.api.services.HostComponentService;
import id.onyx.obdp.server.api.services.HostKerberosIdentityService;
import id.onyx.obdp.server.api.services.HostService;
import id.onyx.obdp.server.api.services.LoggingService;
import id.onyx.obdp.server.api.services.PreUpgradeCheckService;
import id.onyx.obdp.server.api.services.PrivilegeService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.RequestScheduleService;
import id.onyx.obdp.server.api.services.RequestService;
import id.onyx.obdp.server.api.services.ServiceService;
import id.onyx.obdp.server.api.services.UpgradeService;
import id.onyx.obdp.server.api.services.UpgradeSummaryService;
import id.onyx.obdp.server.api.services.WidgetLayoutService;
import id.onyx.obdp.server.api.services.WidgetService;
import id.onyx.obdp.server.api.services.WorkflowService;
import id.onyx.obdp.server.api.services.parsers.BodyParseException;
import id.onyx.obdp.server.controller.ClusterArtifactResponse;
import id.onyx.obdp.server.controller.ClusterResponse;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.state.Clusters;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusters")
@Api(value="Clusters", description="Endpoint for cluster-specific operations")
public class ClusterService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterService.class);
    public static final String INVALID_KERBEROS_CHAR = "^\"[=+@].*";
    private final Gson gson = new Gson();
    private static final String CLUSTER_REQUEST_TYPE = "id.onyx.obdp.server.api.services.ClusterRequestSwagger";
    private static final String ARTIFACT_REQUEST_TYPE = "id.onyx.obdp.server.controller.ClusterArtifactRequest";
    private final Clusters clusters;

    public ClusterService() {
        this.clusters = OBDPServer.getController().getClusters();
    }

    protected ClusterService(Clusters clusters) {
        this.clusters = clusters;
    }

    @GET
    @Path(value="{clusterName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns information about a specific cluster", response=ClusterResponse.ClusterResponseWrapper.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="Clusters/*")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getCluster(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName) {
        ResourceInstance resource = this.createClusterResource(clusterName);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns all clusters", response=ClusterResponse.ClusterResponseWrapper.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getClusters(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        ResourceInstance resource = this.createClusterResource(null);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @POST
    @Path(value="{clusterName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates a cluster")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.api.services.ClusterRequestSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createCluster(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName) {
        ResourceInstance resource = this.createClusterResource(clusterName);
        return this.handleRequest(headers, body, ui, Request.Type.POST, resource);
    }

    @PUT
    @Path(value="{clusterName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates a cluster")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.api.services.ClusterRequestSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateCluster(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName) {
        ResourceInstance resource = this.createClusterResource(clusterName);
        return this.handleRequest(headers, body, ui, Request.Type.PUT, resource);
    }

    @DELETE
    @Path(value="{clusterName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes a cluster")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteCluster(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName) {
        ResourceInstance resource = this.createClusterResource(clusterName);
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, resource);
    }

    @GET
    @Path(value="{clusterName}/artifacts")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns all artifacts associated with the cluster", response=ClusterArtifactResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getClusterArtifacts(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName) {
        ResourceInstance resource = this.createArtifactResource(clusterName, null);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Path(value="{clusterName}/artifacts/{artifactName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get the details of a cluster artifact", response=ClusterArtifactResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getClusterArtifact(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName, @ApiParam(required=true) @PathParam(value="artifactName") String artifactName) {
        ResourceInstance resource = this.createArtifactResource(clusterName, artifactName);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @POST
    @Path(value="{clusterName}/artifacts/{artifactName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates a cluster artifact")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ClusterArtifactRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createClusterArtifact(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName, @ApiParam(required=true) @PathParam(value="artifactName") String artifactName) {
        ResourceInstance resource = this.createArtifactResource(clusterName, artifactName);
        return this.handleRequest(headers, body, ui, Request.Type.POST, resource);
    }

    @PUT
    @Path(value="{clusterName}/artifacts")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates multiple artifacts")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ClusterArtifactRequest", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateClusterArtifacts(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName) {
        ResourceInstance resource = this.createArtifactResource(clusterName, null);
        return this.handleRequest(headers, body, ui, Request.Type.PUT, resource);
    }

    @PUT
    @Path(value="{clusterName}/artifacts/{artifactName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates a single artifact")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ClusterArtifactRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateClusterArtifact(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName, @ApiParam(required=true) @PathParam(value="artifactName") String artifactName) throws BodyParseException {
        if ("kerberos_descriptor".equals(artifactName)) {
            LOG.info("Validating body For kerberos_descriptor");
            if (this.parseBody(body)) {
                throw new BodyParseException("Bad request received");
            }
        }
        ResourceInstance resource = this.createArtifactResource(clusterName, artifactName);
        return this.handleRequest(headers, body, ui, Request.Type.PUT, resource);
    }

    @DELETE
    @Path(value="{clusterName}/artifacts/{artifactName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes a single artifact")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteClusterArtifact(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName, @ApiParam(required=true) @PathParam(value="artifactName") String artifactName) {
        ResourceInstance resource = this.createArtifactResource(clusterName, artifactName);
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, resource);
    }

    @DELETE
    @Path(value="{clusterName}/artifacts")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes all artifacts of a cluster that match the provided predicate")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteClusterArtifacts(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="clusterName") String clusterName) {
        ResourceInstance resource = this.createArtifactResource(clusterName, null);
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, resource);
    }

    @Path(value="{clusterName}/hosts")
    public HostService getHostHandler(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new HostService(clusterName);
    }

    @Path(value="{clusterName}/services")
    public ServiceService getServiceHandler(@Context Request request, @ApiParam @PathParam(value="clusterName") String clusterName) {
        return new ServiceService(clusterName);
    }

    @Path(value="{clusterName}/configurations")
    public ConfigurationService getConfigurationHandler(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new ConfigurationService(clusterName);
    }

    @Path(value="{clusterName}/requests")
    public RequestService getRequestHandler(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new RequestService(clusterName);
    }

    @Path(value="{clusterName}/host_components")
    public HostComponentService getHostComponentHandler(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new HostComponentService(clusterName, null);
    }

    @Path(value="{clusterName}/kerberos_identities")
    public HostKerberosIdentityService getHostKerberosIdentityHandler(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new HostKerberosIdentityService(clusterName, null);
    }

    @Path(value="{clusterName}/components")
    public ComponentService getComponentHandler(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new ComponentService(clusterName, null);
    }

    @Path(value="{clusterName}/workflows")
    public WorkflowService getWorkflowHandler(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new WorkflowService(clusterName);
    }

    @Path(value="{clusterName}/config_groups")
    public ConfigGroupService getConfigGroupService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new ConfigGroupService(clusterName);
    }

    @Path(value="{clusterName}/request_schedules")
    public RequestScheduleService getRequestScheduleService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new RequestScheduleService(clusterName);
    }

    @Path(value="{clusterName}/alert_definitions")
    public AlertDefinitionService getAlertDefinitionService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new AlertDefinitionService(clusterName);
    }

    @Path(value="{clusterName}/alert_groups")
    public AlertGroupService getAlertGroups(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new AlertGroupService(clusterName);
    }

    @Path(value="{clusterName}/privileges")
    public PrivilegeService getPrivilegeService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new ClusterPrivilegeService(clusterName);
    }

    @Path(value="{clusterName}/alerts")
    public AlertService getAlertService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new AlertService(clusterName, null, null);
    }

    @Path(value="{clusterName}/alert_history")
    public AlertHistoryService getAlertHistoryService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new AlertHistoryService(clusterName, null, null);
    }

    @Path(value="{clusterName}/alert_notices")
    public AlertNoticeService getAlertNoticeService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new AlertNoticeService(clusterName);
    }

    @Path(value="{clusterName}/stack_versions")
    public ClusterStackVersionService getClusterStackVersionService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new ClusterStackVersionService(clusterName);
    }

    @Path(value="{clusterName}/upgrades")
    public UpgradeService getUpgradeService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new UpgradeService(clusterName);
    }

    @Path(value="{clusterName}/upgrade_summary")
    public UpgradeSummaryService getUpgradeSummaryService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new UpgradeSummaryService(clusterName);
    }

    @Path(value="{clusterName}/rolling_upgrades_check")
    public PreUpgradeCheckService getPreUpgradeCheckService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new PreUpgradeCheckService(clusterName);
    }

    @Path(value="{clusterName}/widget_layouts")
    public WidgetLayoutService getWidgetLayoutService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new WidgetLayoutService(clusterName);
    }

    @Path(value="{clusterName}/widgets")
    public WidgetService getWidgetService(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new WidgetService(clusterName);
    }

    @Path(value="{clusterName}/credentials")
    public CredentialService getCredentials(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new CredentialService(clusterName);
    }

    @Path(value="{clusterName}/kerberos_descriptors")
    public ClusterKerberosDescriptorService getCompositeKerberosDescriptor(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return new ClusterKerberosDescriptorService(clusterName);
    }

    @Path(value="{clusterName}/logging")
    public LoggingService getLogging(@Context Request request, @PathParam(value="clusterName") String clusterName) {
        return OBDPServer.getController().getLoggingService(clusterName);
    }

    ResourceInstance createClusterResource(String clusterName) {
        return this.createResource(Resource.Type.Cluster, Collections.singletonMap(Resource.Type.Cluster, clusterName));
    }

    ResourceInstance createArtifactResource(String clusterName, String artifactName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Artifact, artifactName);
        return this.createResource(Resource.Type.Artifact, mapIds);
    }

    private boolean parseBody(String body) {
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(body, JsonObject.class);
        if (jsonObject == null) {
            return false;
        }
        JsonElement artifact_data = jsonObject.get("artifact_data");
        if (artifact_data == null) {
            return false;
        }
        JsonArray identities = artifact_data.getAsJsonObject().getAsJsonArray("identities");
        if (identities != null && this.checkKeytabsPrincipal(identities)) {
            return true;
        }
        JsonArray services = artifact_data.getAsJsonObject().getAsJsonArray("services");
        for (int i = 0; i < services.size(); ++i) {
            JsonArray components = services.get(i).getAsJsonObject().get("components").getAsJsonArray();
            if (services.get(i).getAsJsonObject().get("identities") != null && this.checkKeytabsPrincipal((JsonArray)services.get(i).getAsJsonObject().get("identities"))) {
                return true;
            }
            for (int ii = 0; ii < components.size(); ++ii) {
                JsonArray componentsIdentities = (JsonArray)components.get(ii).getAsJsonObject().get("identities");
                if (componentsIdentities == null || !this.checkKeytabsPrincipal(componentsIdentities)) continue;
                return true;
            }
        }
        Set properties = artifact_data.getAsJsonObject().getAsJsonObject("properties").entrySet();
        for (Map.Entry entry : properties) {
            boolean res = this.validateValues(String.valueOf(entry.getValue()));
            if (!res) continue;
            return true;
        }
        return false;
    }

    private boolean checkKeytabsPrincipal(JsonArray identities) {
        String keytabFile = "";
        String principalValue = "";
        for (int i = 0; i < identities.size(); ++i) {
            if (identities.get(i).getAsJsonObject().get("keytab") != null) {
                keytabFile = String.valueOf(identities.get(i).getAsJsonObject().get("keytab").getAsJsonObject().get("file"));
            }
            if (identities.get(i).getAsJsonObject().get("principal") != null) {
                principalValue = String.valueOf(identities.get(i).getAsJsonObject().get("principal").getAsJsonObject().get("value"));
            }
            if (!keytabFile.isEmpty() && !"null".equals(keytabFile) && this.validateValues(keytabFile)) {
                return true;
            }
            if (principalValue.isEmpty() || "null".equals(principalValue) || !this.validateValues(principalValue)) continue;
            return true;
        }
        return false;
    }

    private boolean validateValues(String values) {
        return values.matches(INVALID_KERBEROS_CHAR);
    }
}

