/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class ClusterKerberosDescriptorService
extends BaseService {
    private String clusterName;

    public ClusterKerberosDescriptorService(String clusterName) {
        this.clusterName = clusterName;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getKerberosDescriptors(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(null));
    }

    @GET
    @Path(value="{type}")
    @Produces(value={"text/plain"})
    public Response getKerberosDescriptor(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="type") String type) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(type));
    }

    ResourceInstance createResource(String type) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.clusterName);
        mapIds.put(Resource.Type.ClusterKerberosDescriptor, type);
        return this.createResource(Resource.Type.ClusterKerberosDescriptor, mapIds);
    }
}

