/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.BlueprintSwagger;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/blueprints/")
@Api(value="Blueprints", description="Endpoint for blueprint specific operations")
public class BlueprintService
extends BaseService {
    public static final String BLUEPRINT_REQUEST_TYPE = "id.onyx.obdp.server.controller.BlueprintSwagger";

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all blueprints", nickname="BlueprintService#getBlueprints", response=BlueprintSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Blueprints/blueprint_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", defaultValue="Blueprints/blueprint_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=500, message="Internal server error")})
    public Response getBlueprints(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createBlueprintResource(null));
    }

    @GET
    @Path(value="{blueprintName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get the details of a blueprint", nickname="BlueprintService#getBlueprint", response=BlueprintSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Blueprints/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=500, message="Internal server error")})
    public Response getBlueprint(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="blueprintName") String blueprintName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createBlueprintResource(blueprintName));
    }

    @POST
    @Path(value="{blueprintName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates a blueprint", nickname="BlueprintService#createBlueprint")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.BlueprintSwagger", paramType="body", allowMultiple=false)})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="The requested resource doesn't exist."), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createBlueprint(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="blueprintName") String blueprintName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createBlueprintResource(blueprintName));
    }

    @DELETE
    @Path(value="{blueprintName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes a blueprint", nickname="BlueprintService#deleteBlueprint")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteBlueprint(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="blueprintName") String blueprintName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createBlueprintResource(blueprintName));
    }

    @DELETE
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes multiple blueprints that match the predicate. Omitting the predicate will delete all blueprints.", nickname="BlueprintService#deleteBlueprints")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteBlueprints(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createBlueprintResource(null));
    }

    ResourceInstance createBlueprintResource(String blueprintName) {
        return this.createResource(Resource.Type.Blueprint, Collections.singletonMap(Resource.Type.Blueprint, blueprintName));
    }
}

