/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.resources.ResourceInstanceFactory;
import id.onyx.obdp.server.api.resources.ResourceInstanceFactoryImpl;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.RequestBody;
import id.onyx.obdp.server.api.services.RequestFactory;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.api.services.parsers.BodyParseException;
import id.onyx.obdp.server.api.services.parsers.JsonRequestBodyParser;
import id.onyx.obdp.server.api.services.parsers.RequestBodyParser;
import id.onyx.obdp.server.api.services.serializers.CsvSerializer;
import id.onyx.obdp.server.api.services.serializers.JsonSerializer;
import id.onyx.obdp.server.api.services.serializers.ResultSerializer;
import id.onyx.obdp.server.audit.request.RequestAuditLogger;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.utils.RetryHelper;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseService {
    public static final MediaType MEDIA_TYPE_TEXT_CSV_TYPE = new MediaType("text", "csv");
    public static final String MSG_SUCCESSFUL_OPERATION = "Successful operation";
    public static final String MSG_REQUEST_ACCEPTED = "Request is accepted, but not completely processed yet";
    public static final String MSG_INVALID_ARGUMENTS = "Invalid arguments";
    public static final String MSG_INVALID_REQUEST = "Invalid request";
    public static final String MSG_CLUSTER_NOT_FOUND = "Cluster not found";
    public static final String MSG_CLUSTER_OR_HOST_NOT_FOUND = "Cluster or host not found";
    public static final String MSG_VIEW_NOT_FOUND = "View not found";
    public static final String MSG_NOT_AUTHENTICATED = "Not authenticated";
    public static final String MSG_PERMISSION_DENIED = "Not permitted to perform the operation";
    public static final String MSG_SERVER_ERROR = "Internal server error";
    public static final String MSG_RESOURCE_ALREADY_EXISTS = "The requested resource already exists.";
    public static final String MSG_RESOURCE_NOT_FOUND = "The requested resource doesn't exist.";
    public static final String QUERY_FIELDS = "fields";
    public static final String QUERY_FILTER_DESCRIPTION = "Filter fields in the response (identifier fields are mandatory)";
    public static final String QUERY_SORT = "sortBy";
    public static final String QUERY_SORT_DESCRIPTION = "Sort resources in result by (asc | desc)";
    public static final String QUERY_PAGE_SIZE = "page_size";
    public static final String QUERY_PAGE_SIZE_DESCRIPTION = "The number of resources to be returned for the paged response.";
    public static final String DEFAULT_PAGE_SIZE = "10";
    public static final String QUERY_FROM = "from";
    public static final String QUERY_FROM_DESCRIPTION = "The starting page resource (inclusive).  \"start\" is also accepted.";
    public static final String QUERY_FROM_VALUES = "range[0, infinity]";
    public static final String DEFAULT_FROM = "0";
    public static final String QUERY_TO = "to";
    public static final String QUERY_TO_DESCRIPTION = "The ending page resource (inclusive).  \"end\" is also accepted.";
    public static final String QUERY_TO_TYPE = "integer";
    public static final String QUERY_TO_VALUES = "range[1, infinity]";
    public static final String QUERY_PREDICATE = "{predicate}";
    public static final String QUERY_PREDICATE_DESCRIPTION = "The predicate to filter resources by. Omitting the predicate will match all resources.";
    public static final String RESPONSE_CONTAINER_LIST = "List";
    public static final String DATA_TYPE_INT = "integer";
    public static final String DATA_TYPE_STRING = "string";
    public static final String PARAM_TYPE_QUERY = "query";
    public static final String PARAM_TYPE_BODY = "body";
    public static final String FIELDS_SEPARATOR = ", ";
    private static final Logger LOG = LoggerFactory.getLogger(BaseService.class);
    private ResourceInstanceFactory m_resourceFactory = new ResourceInstanceFactoryImpl();
    private ResultSerializer m_serializer = new JsonSerializer();
    protected static RequestAuditLogger requestAuditLogger;

    public static void init(RequestAuditLogger instance) {
        requestAuditLogger = instance;
    }

    protected Response handleRequest(HttpHeaders headers, String body, UriInfo uriInfo, Request.Type requestType, ResourceInstance resource) {
        return this.handleRequest(headers, body, uriInfo, requestType, null, resource);
    }

    protected Response handleRequest(HttpHeaders headers, String body, UriInfo uriInfo, Request.Type requestType, MediaType mediaType, ResourceInstance resource) {
        RequestBody rb = new RequestBody();
        rb.setBody(body);
        Request request = this.getRequestFactory().createRequest(headers, rb, uriInfo, requestType, resource);
        Result result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.OK));
        try {
            Set<RequestBody> requestBodySet = this.getBodyParser().parse(body);
            Iterator<RequestBody> iterator = requestBodySet.iterator();
            while (iterator.hasNext() && result.getStatus().getStatus().equals((Object)ResultStatus.STATUS.OK)) {
                RequestBody requestBody = iterator.next();
                request = this.getRequestFactory().createRequest(headers, requestBody, uriInfo, requestType, resource);
                result = request.process();
                if (!ResultStatus.STATUS.OK.equals((Object)result.getStatus().getStatus())) continue;
                requestAuditLogger.log(request, result);
            }
            if (requestBodySet.isEmpty() || !ResultStatus.STATUS.OK.equals((Object)result.getStatus().getStatus())) {
                requestAuditLogger.log(request, result);
            }
        }
        catch (BodyParseException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, e.getMessage()));
            LOG.error("Bad request received: " + e.getMessage());
            requestAuditLogger.log(request, result);
        }
        catch (Throwable t) {
            requestAuditLogger.log(request, new ResultImpl(new ResultStatus(ResultStatus.STATUS.SERVER_ERROR, t.getMessage())));
            throw t;
        }
        ResultSerializer serializer = mediaType == null ? this.getResultSerializer() : this.getResultSerializer(mediaType);
        Response.ResponseBuilder builder = Response.status((int)result.getStatus().getStatusCode()).entity(serializer.serialize(result));
        if (mediaType != null) {
            builder.type(mediaType);
        }
        RetryHelper.clearAffectedClusters();
        return builder.build();
    }

    RequestFactory getRequestFactory() {
        return new RequestFactory();
    }

    protected ResourceInstance createResource(Resource.Type type, Map<Resource.Type, String> mapIds) {
        return this.m_resourceFactory.createResource(type, mapIds);
    }

    protected ResultSerializer getResultSerializer(MediaType mediaType) {
        final ResultSerializer serializer = this.getResultSerializer();
        final JSON jsonParser = new JSON();
        if (mediaType.equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
            return new ResultSerializer(){

                @Override
                public Object serialize(Result result) {
                    return serializer.serialize(result).toString();
                }

                @Override
                public Object serializeError(ResultStatus error) {
                    return serializer.serializeError(error).toString();
                }
            };
        }
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            return new ResultSerializer(){

                @Override
                public Object serialize(Result result) {
                    return jsonParser.parse((JSON.Source)new JSON.StringSource(serializer.serialize(result).toString()));
                }

                @Override
                public Object serializeError(ResultStatus error) {
                    return jsonParser.parse((JSON.Source)new JSON.StringSource(serializer.serializeError(error).toString()));
                }
            };
        }
        if (mediaType.equals((Object)MEDIA_TYPE_TEXT_CSV_TYPE)) {
            return new CsvSerializer();
        }
        throw new IllegalArgumentException("The media type " + mediaType + " is not supported.");
    }

    protected ResultSerializer getResultSerializer() {
        return this.m_serializer;
    }

    protected RequestBodyParser getBodyParser() {
        return new JsonRequestBodyParser();
    }
}

