/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.handlers.RequestHandler;
import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.api.predicate.PredicateCompiler;
import id.onyx.obdp.server.api.query.render.Renderer;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.RequestBody;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultPostProcessor;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.controller.internal.PageRequestImpl;
import id.onyx.obdp.server.controller.internal.SortRequestImpl;
import id.onyx.obdp.server.controller.internal.TemporalInfoImpl;
import id.onyx.obdp.server.controller.spi.PageRequest;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.SortRequest;
import id.onyx.obdp.server.controller.spi.SortRequestProperty;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import id.onyx.obdp.server.utils.RequestUtils;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRequest
implements Request {
    private UriInfo m_uriInfo;
    private HttpHeaders m_headers;
    private RequestBody m_body;
    private String m_remoteAddress;
    private Predicate m_predicate;
    private ResourceInstance m_resource;
    public static final int DEFAULT_PAGE_SIZE = 20;
    public static final String PAGE_SIZE_PROPERTY_KEY = "Request_Info/max_results";
    public static final String ASC_ORDER_PROPERTY_KEY = "Request_Info/asc_order";
    private Renderer m_renderer;
    private static final Logger LOG = LoggerFactory.getLogger(Request.class);

    public BaseRequest(HttpHeaders headers, RequestBody body, UriInfo uriInfo, ResourceInstance resource) {
        this.m_headers = headers;
        this.m_uriInfo = uriInfo;
        this.m_resource = resource;
        this.m_body = body;
        this.m_remoteAddress = RequestUtils.getRemoteAddress();
    }

    @Override
    public Result process() {
        Result result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling API Request: '{}'", (Object)this.getURI());
        }
        try {
            this.parseRenderer();
            this.parseQueryPredicate();
            result = this.getRequestHandler().handleRequest(this);
        }
        catch (InvalidQueryException e) {
            String message = "Unable to compile query predicate: " + e.getMessage();
            LOG.error(message, (Throwable)e);
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, message));
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid Request: " + e.getMessage();
            LOG.error(message, (Throwable)e);
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, message));
        }
        if (!result.getStatus().isErrorState()) {
            this.getResultPostProcessor().process(result);
        }
        return result;
    }

    @Override
    public ResourceInstance getResource() {
        return this.m_resource;
    }

    @Override
    public String getURI() {
        return this.m_uriInfo.getRequestUri().toASCIIString();
    }

    @Override
    public int getAPIVersion() {
        return 1;
    }

    @Override
    public Predicate getQueryPredicate() {
        return this.m_predicate;
    }

    @Override
    public Map<String, TemporalInfo> getFields() {
        Map<String, TemporalInfo> mapProperties;
        String partialResponseFields = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)"fields");
        if (partialResponseFields == null) {
            mapProperties = Collections.emptyMap();
        } else {
            HashSet<String> setMatches = new HashSet<String>();
            Pattern re = Pattern.compile("[^,\\[]*?\\[[^\\]]*?\\]|[^,]+");
            Matcher m = re.matcher(partialResponseFields);
            while (m.find()) {
                for (int groupIdx = 0; groupIdx < m.groupCount() + 1; ++groupIdx) {
                    setMatches.add(m.group(groupIdx));
                }
            }
            mapProperties = new HashMap<String, TemporalInfo>(setMatches.size());
            for (String field : setMatches) {
                TemporalInfoImpl temporalInfo = null;
                if (field.contains("[")) {
                    String[] temporalData = field.substring(field.indexOf(91) + 1, field.indexOf(93)).split(",");
                    field = field.substring(0, field.indexOf(91));
                    long start = Long.parseLong(temporalData[0].trim());
                    long end = -1L;
                    long step = -1L;
                    if (temporalData.length >= 2) {
                        end = Long.parseLong(temporalData[1].trim());
                        if (temporalData.length == 3) {
                            step = Long.parseLong(temporalData[2].trim());
                        }
                    }
                    temporalInfo = new TemporalInfoImpl(start, end, step);
                }
                mapProperties.put(field, temporalInfo);
            }
        }
        return mapProperties;
    }

    @Override
    public Renderer getRenderer() {
        return this.m_renderer;
    }

    @Override
    public Map<String, List<String>> getHttpHeaders() {
        return this.m_headers.getRequestHeaders();
    }

    @Override
    public PageRequest getPageRequest() {
        PageRequest.StartingPoint startingPoint;
        String pageSize = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)"page_size");
        String from = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)"from");
        String to = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)"to");
        if (pageSize == null && from == null && to == null) {
            return null;
        }
        int offset = 0;
        if (from != null) {
            if (from.equals("start")) {
                startingPoint = PageRequest.StartingPoint.Beginning;
            } else {
                offset = Integer.parseInt(from);
                startingPoint = PageRequest.StartingPoint.OffsetStart;
            }
        } else if (to != null) {
            if (to.equals("end")) {
                startingPoint = PageRequest.StartingPoint.End;
            } else {
                offset = Integer.parseInt(to);
                startingPoint = PageRequest.StartingPoint.OffsetEnd;
            }
        } else {
            startingPoint = PageRequest.StartingPoint.Beginning;
        }
        return new PageRequestImpl(startingPoint, pageSize == null ? 20 : Integer.parseInt(pageSize), offset, null, null);
    }

    @Override
    public RequestBody getBody() {
        return this.m_body;
    }

    protected ResultPostProcessor getResultPostProcessor() {
        return this.m_renderer.getResultPostProcessor(this);
    }

    protected PredicateCompiler getPredicateCompiler() {
        return new PredicateCompiler();
    }

    private boolean isMinimal() {
        String minimal = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)"minimal_response");
        return minimal != null && minimal.equalsIgnoreCase("true");
    }

    private void parseQueryPredicate() throws InvalidQueryException {
        String queryString = this.m_body.getQueryString();
        if (queryString == null) {
            String uri = this.getURI();
            int qsBegin = uri.indexOf("?");
            String string = queryString = qsBegin == -1 ? null : uri.substring(qsBegin + 1);
        }
        if (queryString != null) {
            try {
                Collection<String> ignoredProperties = null;
                switch (this.getRequestType()) {
                    case PUT: {
                        ignoredProperties = this.m_resource.getResourceDefinition().getUpdateDirectives();
                        break;
                    }
                    case POST: {
                        ignoredProperties = this.m_resource.getResourceDefinition().getCreateDirectives();
                        break;
                    }
                    case GET: {
                        ignoredProperties = this.m_resource.getResourceDefinition().getReadDirectives();
                        break;
                    }
                    case DELETE: {
                        ignoredProperties = this.m_resource.getResourceDefinition().getDeleteDirectives();
                        break;
                    }
                }
                this.m_predicate = ignoredProperties == null ? this.getPredicateCompiler().compile(URLDecoder.decode(queryString, "UTF-8")) : this.getPredicateCompiler().compile(URLDecoder.decode(queryString, "UTF-8"), ignoredProperties);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to decode URI: " + e, e);
            }
        }
    }

    private void parseRenderer() {
        String rendererName = this.isMinimal() ? "minimal" : (String)this.m_uriInfo.getQueryParameters().getFirst((Object)"format");
        this.m_renderer = this.m_resource.getResourceDefinition().getRenderer(rendererName);
    }

    @Override
    public SortRequest getSortRequest() {
        String sortByParams = (String)this.m_uriInfo.getQueryParameters().getFirst((Object)"sortBy");
        if (sortByParams != null && !sortByParams.isEmpty()) {
            String[] params = sortByParams.split(",");
            ArrayList<SortRequestProperty> properties = new ArrayList<SortRequestProperty>();
            if (params.length > 0) {
                for (String property : params) {
                    SortRequest.Order order = SortRequest.Order.ASC;
                    String propertyId = property;
                    int idx = property.indexOf(".");
                    if (idx != -1) {
                        order = SortRequest.Order.valueOf(property.substring(idx + 1).toUpperCase());
                        propertyId = property.substring(0, idx);
                    }
                    properties.add(new SortRequestProperty(propertyId, order));
                }
            }
            return new SortRequestImpl(properties);
        }
        return null;
    }

    protected abstract RequestHandler getRequestHandler();

    @Override
    public String getRemoteAddress() {
        return this.m_remoteAddress;
    }
}

