/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.AlertTargetSwagger;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/alert_targets/")
@Api(value="Alerts", description="Endpoint for alert specific operations")
public class AlertTargetService
extends BaseService {
    public static final String ALERT_TARGET_REQUEST_TYPE = "id.onyx.obdp.server.controller.AlertTargetSwagger";

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns all alert targets", response=AlertTargetSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="AlertTarget/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getTargets(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createAlertTargetResource(null));
    }

    @GET
    @Path(value="{targetId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns a single alert target", response=AlertTargetSwagger.class, nickname="getTarget")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="AlertTarget/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getTargets(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="alert target id") @PathParam(value="targetId") Long targetId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createAlertTargetResource(targetId));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates an alert target")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.AlertTargetSwagger", paramType="body"), @ApiImplicitParam(name="validate_config", dataType="string", paramType="query"), @ApiImplicitParam(name="overwrite_existing", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=500, message="Internal server error")})
    public Response createTarget(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createAlertTargetResource(null));
    }

    @PUT
    @Path(value="{targetId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates an alert target")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.AlertTargetSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateTarget(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="targetId") Long targetId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createAlertTargetResource(targetId));
    }

    @DELETE
    @Path(value="{targetId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes an alert target")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteTarget(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="targetId") Long targetId) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createAlertTargetResource(targetId));
    }

    private ResourceInstance createAlertTargetResource(Long targetId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.AlertTarget, null == targetId ? null : targetId.toString());
        return this.createResource(Resource.Type.AlertTarget, mapIds);
    }
}

