/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class AlertNoticeService
extends BaseService {
    private String clusterName = null;

    AlertNoticeService(String clusterName) {
        this.clusterName = clusterName;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getNotices(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResourceInstance(this.clusterName, null));
    }

    @GET
    @Path(value="{alertNoticeId}")
    @Produces(value={"text/plain"})
    public Response getNotice(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="alertNoticeId") Long id) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResourceInstance(this.clusterName, id));
    }

    private ResourceInstance createResourceInstance(String clusterName, Long alertNoticeId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        if (null != alertNoticeId) {
            mapIds.put(Resource.Type.AlertNotice, alertNoticeId.toString());
        }
        return this.createResource(Resource.Type.AlertNotice, mapIds);
    }
}

