/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class AlertHistoryService
extends BaseService {
    private String clusterName = null;
    private String serviceName = null;
    private String hostName = null;

    AlertHistoryService(String clusterName, String serviceName, String hostName) {
        this.clusterName = clusterName;
        this.serviceName = serviceName;
        this.hostName = hostName;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getHistories(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResourceInstance(this.clusterName, null));
    }

    @GET
    @Path(value="{alertHistoryId}")
    @Produces(value={"text/plain"})
    public Response getHistory(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="alertHistoryId") Long id) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResourceInstance(this.clusterName, id));
    }

    private ResourceInstance createResourceInstance(String clusterName, Long historyId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Service, this.serviceName);
        mapIds.put(Resource.Type.Host, this.hostName);
        if (null != historyId) {
            mapIds.put(Resource.Type.AlertHistory, historyId.toString());
        }
        return this.createResource(Resource.Type.AlertHistory, mapIds);
    }
}

