/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class AlertGroupService
extends BaseService {
    private String m_clusterName = null;

    AlertGroupService(String clusterName) {
        this.m_clusterName = clusterName;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getGroups(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createAlertGroupResource(this.m_clusterName, null));
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{groupId}")
    public Response getGroup(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="groupId") Long groupId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createAlertGroupResource(this.m_clusterName, groupId));
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createGroup(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createAlertGroupResource(this.m_clusterName, null));
    }

    @PUT
    @Produces(value={"text/plain"})
    @Path(value="{groupId}")
    public Response updateGroup(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="groupId") Long groupId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createAlertGroupResource(this.m_clusterName, groupId));
    }

    @DELETE
    @Produces(value={"text/plain"})
    @Path(value="{groupId}")
    public Response deleteGroup(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="groupId") Long groupId) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createAlertGroupResource(this.m_clusterName, groupId));
    }

    private ResourceInstance createAlertGroupResource(String clusterName, Long groupId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.m_clusterName);
        mapIds.put(Resource.Type.AlertGroup, null == groupId ? null : groupId.toString());
        return this.createResource(Resource.Type.AlertGroup, mapIds);
    }
}

