/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class AlertDefinitionService
extends BaseService {
    private String clusterName = null;

    AlertDefinitionService(String clusterName) {
        this.clusterName = clusterName;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getDefinitions(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResourceInstance(this.clusterName, null));
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createDefinition(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResourceInstance(this.clusterName, null));
    }

    @PUT
    @Path(value="{alertDefinitionId}")
    @Produces(value={"text/plain"})
    public Response updateDefinition(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="alertDefinitionId") Long id) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResourceInstance(this.clusterName, id));
    }

    @DELETE
    @Path(value="{alertDefinitionId}")
    @Produces(value={"text/plain"})
    public Response deleteDefinition(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="alertDefinitionId") Long id) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createResourceInstance(this.clusterName, id));
    }

    @GET
    @Path(value="{alertDefinitionId}")
    @Produces(value={"text/plain"})
    public Response getDefinitions(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="alertDefinitionId") Long id) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResourceInstance(this.clusterName, id));
    }

    private ResourceInstance createResourceInstance(String clusterName, Long definitionId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.AlertDefinition, null == definitionId ? null : definitionId.toString());
        return this.createResource(Resource.Type.AlertDefinition, mapIds);
    }
}

