/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.ActionResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/actions/")
@Api(value="Actions", description="Endpoint for action definition specific operations")
public class ActionService
extends BaseService {
    private static final String ACTION_REQUEST_TYPE = "id.onyx.obdp.server.controller.ActionRequestSwagger";

    @GET
    @Path(value="{actionName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get the details of an action definition", nickname="ActionService#getActionDefinition", response=ActionResponse.ActionResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Actions/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getActionDefinition(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="actionName") String actionName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createActionDefinitionResource(actionName));
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all action definitions", nickname="ActionService#getActionDefinitions", response=ActionResponse.ActionResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Actions/action_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", defaultValue="Actions/action_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=500, message="Internal server error")})
    public Response getActionDefinitions(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createActionDefinitionResource(null));
    }

    @POST
    @Path(value="{actionName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates an action definition - Currently Not Supported", nickname="ActionService#createActionDefinition")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ActionRequestSwagger", paramType="body", allowMultiple=false)})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createActionDefinition(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="actionName") String actionName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createActionDefinitionResource(actionName));
    }

    @PUT
    @Path(value="{actionName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates an action definition - Currently Not Supported", nickname="ActionService#updateActionDefinition")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ActionRequestSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateActionDefinition(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="actionName") String actionName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createActionDefinitionResource(actionName));
    }

    @DELETE
    @Path(value="{actionName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes an action definition - Currently Not Supported", nickname="ActionService#deleteActionDefinition")
    @ApiResponses(value={@ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteActionDefinition(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="actionName") String actionName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createActionDefinitionResource(actionName));
    }

    ResourceInstance createActionDefinitionResource(String actionName) {
        return this.createResource(Resource.Type.Action, Collections.singletonMap(Resource.Type.Action, actionName));
    }
}

