/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.rest;

import com.google.inject.Inject;
import id.onyx.obdp.server.KdcServerConnectionVerification;
import id.onyx.obdp.server.StaticallyInject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;

@StaticallyInject
@Path(value="/kdc_check/")
public class KdcServerReachabilityCheck {
    private static final String REACHABLE = "REACHABLE";
    private static final String UNREACHABLE = "UNREACHABLE";
    @Inject
    private static KdcServerConnectionVerification kdcConnectionChecker;

    @GET
    @Path(value="{hosts}")
    @Produces(value={"text/plain"})
    public String plainTextCheck(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="hosts") String hosts) {
        String status = UNREACHABLE;
        if (hosts != null) {
            String[] kdcHosts;
            for (String kdcHost : kdcHosts = hosts.split(",")) {
                if ((kdcHost = kdcHost.trim()).isEmpty() || !kdcConnectionChecker.isKdcReachable(kdcHost)) continue;
                status = REACHABLE;
                break;
            }
        }
        return status;
    }

    @GET
    @Path(value="{hostname}")
    @Produces(value={"text/xml"})
    public String xmlCheck(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="hostname") String kdcServerHostName) {
        String status = UNREACHABLE;
        if (kdcConnectionChecker.isKdcReachable(kdcServerHostName)) {
            status = REACHABLE;
        }
        return "<?xml version=\"1.0\"?>" + "<status>" + status + "</status>";
    }

    @GET
    @Path(value="{hostname}")
    @Produces(value={"text/html"})
    public String htmlCheck(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="hostname") String kdcServerHostName) {
        String status = UNREACHABLE;
        if (kdcConnectionChecker.isKdcReachable(kdcServerHostName)) {
            status = REACHABLE;
        }
        return "<html>\n" + "<title>" + "Status" + "</title>\n" + "<body><h1>" + status + "</body></h1>\n" + "</html> ";
    }
}

