/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.rest;

import com.google.inject.Inject;
import id.onyx.obdp.server.bootstrap.BSHostStatus;
import id.onyx.obdp.server.bootstrap.BSResponse;
import id.onyx.obdp.server.bootstrap.BootStrapImpl;
import id.onyx.obdp.server.bootstrap.BootStrapStatus;
import id.onyx.obdp.server.bootstrap.SshHostInfo;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/bootstrap")
public class BootStrapResource {
    private static BootStrapImpl bsImpl;
    private static final Logger LOG;

    @Inject
    public static void init(BootStrapImpl instance) {
        bsImpl = instance;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/xml"})
    public BSResponse bootStrap(SshHostInfo sshInfo, @Context UriInfo uriInfo) {
        this.normalizeHosts(sshInfo);
        BSResponse resp = bsImpl.runBootStrap(sshInfo);
        return resp;
    }

    @GET
    @Path(value="/{requestId}")
    @Produces(value={"application/json", "application/xml"})
    public BootStrapStatus getBootStrapStatus(@PathParam(value="requestId") long requestId, @Context UriInfo info) {
        BootStrapStatus status = bsImpl.getStatus(requestId);
        if (status == null) {
            throw new WebApplicationException(Response.Status.NO_CONTENT);
        }
        return status;
    }

    @GET
    @Path(value="/hosts")
    @Produces(value={"application/json"})
    public List<BSHostStatus> getBootStrapHosts(@Context UriInfo uriInfo) {
        List<BSHostStatus> allStatus = bsImpl.getHostInfo(null);
        if (0 == allStatus.size()) {
            throw new WebApplicationException(Response.Status.NO_CONTENT);
        }
        return allStatus;
    }

    @POST
    @Path(value="/hosts")
    @Produces(value={"application/json"})
    public List<BSHostStatus> getBootStrapHosts(SshHostInfo info, @Context UriInfo uriInfo) {
        List<BSHostStatus> allStatus = bsImpl.getHostInfo(info.getHosts());
        if (0 == allStatus.size()) {
            throw new WebApplicationException(Response.Status.NO_CONTENT);
        }
        return allStatus;
    }

    private void normalizeHosts(SshHostInfo info) {
        ArrayList<String> validHosts = new ArrayList<String>();
        ArrayList<String> newHosts = new ArrayList<String>();
        for (String host : info.getHosts()) {
            try {
                InetAddress addr = InetAddress.getByName(host);
                if (!validHosts.contains(addr.getHostAddress())) {
                    validHosts.add(addr.getHostAddress());
                    newHosts.add(host);
                    continue;
                }
                LOG.warn("Host " + host + " has already been targeted to be bootstrapped.");
            }
            catch (UnknownHostException e) {
                LOG.warn("Host " + host + " cannot be determined.");
            }
        }
        info.setHosts(newHosts);
    }

    static {
        LOG = LoggerFactory.getLogger(BootStrapResource.class);
    }
}

