/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.WidgetResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WidgetLayoutResourceDefinition
extends BaseResourceDefinition {
    public WidgetLayoutResourceDefinition() {
        super(Resource.Type.WidgetLayout);
    }

    @Override
    public String getPluralName() {
        return "widget_layouts";
    }

    @Override
    public String getSingularName() {
        return "widget_layout";
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        List<ResourceDefinition.PostProcessor> listProcessors = super.getPostProcessors();
        listProcessors.add(new WidgetLayoutHrefProcessor());
        return listProcessors;
    }

    private class WidgetLayoutHrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private WidgetLayoutHrefProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            TreeNode<Resource> parent = resultNode.getParent();
            for (TreeNode<Resource> node : parent.getChildren()) {
                if (node.getObject().getPropertiesMap().get("WidgetLayoutInfo") == null || node.getObject().getPropertiesMap().get("WidgetLayoutInfo").get("widgets") == null) continue;
                ArrayList widgetsList = (ArrayList)node.getObject().getPropertiesMap().get("WidgetLayoutInfo").get("widgets");
                for (Object widgetObject : widgetsList) {
                    HashMap widgetMap = (HashMap)widgetObject;
                    if (((WidgetResponse)widgetMap.get("WidgetInfo")).getId() == null) continue;
                    String widgetId = ((WidgetResponse)widgetMap.get("WidgetInfo")).getId().toString();
                    String widgetHref = href.substring(0, href.indexOf("/widget_layouts") + 1) + "widgets/" + widgetId;
                    widgetMap.put("href", widgetHref);
                }
            }
        }
    }
}

