/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StackVersionResourceDefinition
extends BaseResourceDefinition {
    public StackVersionResourceDefinition() {
        super(Resource.Type.StackVersion);
    }

    @Override
    public String getPluralName() {
        return "versions";
    }

    @Override
    public String getSingularName() {
        return "version";
    }

    @Override
    public Set<SubResourceDefinition> getSubResourceDefinitions() {
        HashSet<SubResourceDefinition> children = new HashSet<SubResourceDefinition>();
        children.add(new SubResourceDefinition(Resource.Type.OperatingSystem));
        children.add(new SubResourceDefinition(Resource.Type.StackService));
        children.add(new SubResourceDefinition(Resource.Type.StackLevelConfiguration));
        children.add(new SubResourceDefinition(Resource.Type.RepositoryVersion));
        children.add(new SubResourceDefinition(Resource.Type.StackArtifact));
        children.add(new SubResourceDefinition(Resource.Type.CompatibleRepositoryVersion));
        children.add(new SubResourceDefinition(Resource.Type.Mpack, null, false));
        return children;
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        ArrayList<ResourceDefinition.PostProcessor> listProcessors = new ArrayList<ResourceDefinition.PostProcessor>();
        listProcessors.add(new StackVersionHrefProcessor());
        listProcessors.add(new StackVersionPostProcessor());
        return listProcessors;
    }

    private class StackVersionHrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private StackVersionHrefProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            if (((String)href).contains("/mpacks/")) {
                ResourceImpl mpack = (ResourceImpl)resultNode.getObject();
                Map<String, Map<String, Object>> mapInfo = mpack.getPropertiesMap();
                Map<String, Object> versionInfo = mapInfo.get("Versions");
                int idx = ((String)href).indexOf("mpacks/");
                String stackName = (String)versionInfo.get("stack_name");
                String stackVersion = (String)versionInfo.get("stack_version");
                href = ((String)href).substring(0, idx) + "stacks/" + stackName + "/versions/" + stackVersion;
                resultNode.setProperty("href", href);
            } else {
                super.process(request, resultNode, (String)href);
            }
        }
    }

    private class StackVersionPostProcessor
    implements ResourceDefinition.PostProcessor {
        private StackVersionPostProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            if (href.contains("/mpacks/")) {
                resultNode.setName("stack");
            }
        }
    }
}

