/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.List;

public class ServiceConfigVersionResourceDefinition
extends BaseResourceDefinition {
    public ServiceConfigVersionResourceDefinition() {
        super(Resource.Type.ServiceConfigVersion);
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        List<ResourceDefinition.PostProcessor> listProcessors = super.getPostProcessors();
        listProcessors.add(new HrefProcessor());
        return listProcessors;
    }

    @Override
    public String getPluralName() {
        return "service_config_versions";
    }

    @Override
    public String getSingularName() {
        return "service_config_version";
    }

    private class HrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private HrefProcessor() {
            super(ServiceConfigVersionResourceDefinition.this);
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            if (resultNode.getObject().getType() == Resource.Type.ServiceConfigVersion) {
                if (!((String)href).endsWith("/")) {
                    href = (String)href + "/";
                }
                String clustersToken = "/clusters";
                int idx = ((String)href).indexOf(clustersToken) + clustersToken.length() + 1;
                idx = ((String)href).indexOf("/", idx) + 1;
                String serviceName = (String)resultNode.getObject().getPropertyValue("service_name");
                Long version = (Long)resultNode.getObject().getPropertyValue("service_config_version");
                href = ((String)href).substring(0, idx) + "configurations/service_config_versions?service_name=" + serviceName + "&service_config_version=" + version;
                resultNode.setProperty("href", href);
            } else {
                super.process(request, resultNode, (String)href);
            }
        }
    }
}

