/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.Schema;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import java.util.ArrayList;
import java.util.List;

public class RootServiceHostComponentResourceDefinition
extends BaseResourceDefinition {
    public RootServiceHostComponentResourceDefinition(Resource.Type resourceType) {
        super(resourceType);
    }

    public RootServiceHostComponentResourceDefinition() {
        super(Resource.Type.RootServiceHostComponent);
    }

    @Override
    public String getPluralName() {
        return "hostComponents";
    }

    @Override
    public String getSingularName() {
        return "hostComponent";
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        ArrayList<ResourceDefinition.PostProcessor> listProcessors = new ArrayList<ResourceDefinition.PostProcessor>();
        listProcessors.add(new RootServiceHostComponentHrefProcessor());
        return listProcessors;
    }

    private class RootServiceHostComponentHrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private RootServiceHostComponentHrefProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            Resource r = resultNode.getObject();
            Schema schema = ClusterControllerHelper.getClusterController().getSchema(r.getType());
            Object host = r.getPropertyValue(schema.getKeyPropertyId(Resource.Type.Host));
            Object hostComponent = r.getPropertyValue(schema.getKeyPropertyId(r.getType()));
            int idx = ((String)href).indexOf("services/") + "services/".length();
            idx = ((String)href).indexOf("/", idx) + 1;
            href = ((String)href).substring(0, idx) + "hosts/" + host + "/hostComponents/" + hostComponent;
            resultNode.setProperty("href", href);
        }
    }
}

