/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.query.QueryImpl;
import id.onyx.obdp.server.api.resources.ActionResourceDefinition;
import id.onyx.obdp.server.api.resources.ActiveWidgetLayoutResourceDefinition;
import id.onyx.obdp.server.api.resources.AlertDefResourceDefinition;
import id.onyx.obdp.server.api.resources.AlertGroupResourceDefinition;
import id.onyx.obdp.server.api.resources.AlertHistoryResourceDefinition;
import id.onyx.obdp.server.api.resources.AlertNoticeResourceDefinition;
import id.onyx.obdp.server.api.resources.AlertResourceDefinition;
import id.onyx.obdp.server.api.resources.AlertTargetResourceDefinition;
import id.onyx.obdp.server.api.resources.AuthResourceDefinition;
import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.BlueprintResourceDefinition;
import id.onyx.obdp.server.api.resources.ClientConfigResourceDefinition;
import id.onyx.obdp.server.api.resources.ClusterResourceDefinition;
import id.onyx.obdp.server.api.resources.CompatibleRepositoryVersionDefinition;
import id.onyx.obdp.server.api.resources.ComponentResourceDefinition;
import id.onyx.obdp.server.api.resources.ComponentStackVersionResourceDefinition;
import id.onyx.obdp.server.api.resources.ConfigGroupResourceDefinition;
import id.onyx.obdp.server.api.resources.ConfigurationResourceDefinition;
import id.onyx.obdp.server.api.resources.CredentialResourceDefinition;
import id.onyx.obdp.server.api.resources.DetachedHostResourceDefinition;
import id.onyx.obdp.server.api.resources.ExtensionLinkResourceDefinition;
import id.onyx.obdp.server.api.resources.ExtensionResourceDefinition;
import id.onyx.obdp.server.api.resources.ExtensionVersionResourceDefinition;
import id.onyx.obdp.server.api.resources.FeedResourceDefinition;
import id.onyx.obdp.server.api.resources.GroupResourceDefinition;
import id.onyx.obdp.server.api.resources.HostComponentProcessResourceDefinition;
import id.onyx.obdp.server.api.resources.HostComponentResourceDefinition;
import id.onyx.obdp.server.api.resources.HostKerberosIdentityResourceDefinition;
import id.onyx.obdp.server.api.resources.HostResourceDefinition;
import id.onyx.obdp.server.api.resources.InstanceResourceDefinition;
import id.onyx.obdp.server.api.resources.JobResourceDefinition;
import id.onyx.obdp.server.api.resources.LdapSyncEventResourceDefinition;
import id.onyx.obdp.server.api.resources.LoggingResourceDefinition;
import id.onyx.obdp.server.api.resources.MemberResourceDefinition;
import id.onyx.obdp.server.api.resources.MpackResourceDefinition;
import id.onyx.obdp.server.api.resources.OperatingSystemResourceDefinition;
import id.onyx.obdp.server.api.resources.PermissionResourceDefinition;
import id.onyx.obdp.server.api.resources.PrivilegeResourceDefinition;
import id.onyx.obdp.server.api.resources.RecommendationResourceDefinition;
import id.onyx.obdp.server.api.resources.RemoteClusterResourceDefinition;
import id.onyx.obdp.server.api.resources.RepositoryResourceDefinition;
import id.onyx.obdp.server.api.resources.RepositoryVersionResourceDefinition;
import id.onyx.obdp.server.api.resources.RequestResourceDefinition;
import id.onyx.obdp.server.api.resources.RequestScheduleResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.resources.ResourceInstanceFactory;
import id.onyx.obdp.server.api.resources.RootServiceComponentResourceDefinition;
import id.onyx.obdp.server.api.resources.RootServiceHostComponentResourceDefinition;
import id.onyx.obdp.server.api.resources.RootServiceResourceDefinition;
import id.onyx.obdp.server.api.resources.ServiceConfigVersionResourceDefinition;
import id.onyx.obdp.server.api.resources.ServiceResourceDefinition;
import id.onyx.obdp.server.api.resources.SimpleResourceDefinition;
import id.onyx.obdp.server.api.resources.StackConfigurationDependencyResourceDefinition;
import id.onyx.obdp.server.api.resources.StackConfigurationResourceDefinition;
import id.onyx.obdp.server.api.resources.StackDependencyResourceDefinition;
import id.onyx.obdp.server.api.resources.StackLevelConfigurationResourceDefinition;
import id.onyx.obdp.server.api.resources.StackResourceDefinition;
import id.onyx.obdp.server.api.resources.StackServiceComponentResourceDefinition;
import id.onyx.obdp.server.api.resources.StackServiceResourceDefinition;
import id.onyx.obdp.server.api.resources.StackVersionResourceDefinition;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.api.resources.TargetClusterResourceDefinition;
import id.onyx.obdp.server.api.resources.TaskAttemptResourceDefinition;
import id.onyx.obdp.server.api.resources.TaskResourceDefinition;
import id.onyx.obdp.server.api.resources.UpgradeResourceDefinition;
import id.onyx.obdp.server.api.resources.UserResourceDefinition;
import id.onyx.obdp.server.api.resources.ValidationResourceDefinition;
import id.onyx.obdp.server.api.resources.VersionDefinitionResourceDefinition;
import id.onyx.obdp.server.api.resources.ViewInstanceResourceDefinition;
import id.onyx.obdp.server.api.resources.ViewPermissionResourceDefinition;
import id.onyx.obdp.server.api.resources.ViewResourceDefinition;
import id.onyx.obdp.server.api.resources.ViewUrlResourceDefinition;
import id.onyx.obdp.server.api.resources.ViewVersionResourceDefinition;
import id.onyx.obdp.server.api.resources.WidgetLayoutResourceDefinition;
import id.onyx.obdp.server.api.resources.WidgetResourceDefinition;
import id.onyx.obdp.server.api.resources.WorkflowResourceDefinition;
import id.onyx.obdp.server.api.services.RootServiceComponentConfigurationService;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.view.ViewRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceInstanceFactoryImpl
implements ResourceInstanceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceInstanceFactoryImpl.class);
    private static final Map<Resource.Type, ResourceDefinition> resourceDefinitions = new HashMap<Resource.Type, ResourceDefinition>();

    @Override
    public ResourceInstance createResource(Resource.Type type, Map<Resource.Type, String> mapIds) {
        try {
            String hostName;
            if (mapIds.containsKey(Resource.Type.Host) && (hostName = mapIds.get(Resource.Type.Host)) != null) {
                mapIds.put(Resource.Type.Host, hostName.toLowerCase());
            }
        }
        catch (Exception e) {
            LOG.error("Lowercase host name value in resource failed with error:" + e);
        }
        ResourceDefinition resourceDefinition = ResourceInstanceFactoryImpl.getResourceDefinition(type, mapIds);
        return new QueryImpl(mapIds, resourceDefinition, ClusterControllerHelper.getClusterController());
    }

    public static void addResourceDefinition(Resource.Type type, ResourceDefinition definition) {
        resourceDefinitions.put(type, definition);
    }

    public static ResourceDefinition getResourceDefinition(Resource.Type type, Map<Resource.Type, String> mapIds) {
        if (resourceDefinitions.containsKey(type)) {
            return resourceDefinitions.get(type);
        }
        return switch (type.getInternalType()) {
            case Resource.InternalType.Cluster -> new ClusterResourceDefinition();
            case Resource.InternalType.Service -> new ServiceResourceDefinition();
            case Resource.InternalType.Host -> mapIds.containsKey(Resource.Type.Cluster) ? new HostResourceDefinition() : new DetachedHostResourceDefinition();
            case Resource.InternalType.Component -> new ComponentResourceDefinition();
            case Resource.InternalType.HostComponent -> new HostComponentResourceDefinition();
            case Resource.InternalType.Action -> new ActionResourceDefinition();
            case Resource.InternalType.Configuration -> new ConfigurationResourceDefinition();
            case Resource.InternalType.ServiceConfigVersion -> new ServiceConfigVersionResourceDefinition();
            case Resource.InternalType.Task -> new TaskResourceDefinition();
            case Resource.InternalType.User -> new UserResourceDefinition();
            case Resource.InternalType.UserAuthenticationSource -> new SimpleResourceDefinition(Resource.Type.UserAuthenticationSource, "source", "sources", new Resource.Type[0]);
            case Resource.InternalType.Group -> new GroupResourceDefinition();
            case Resource.InternalType.Member -> new MemberResourceDefinition();
            case Resource.InternalType.Mpack -> new MpackResourceDefinition();
            case Resource.InternalType.Request -> new RequestResourceDefinition();
            case Resource.InternalType.Stack -> new StackResourceDefinition();
            case Resource.InternalType.StackVersion -> new StackVersionResourceDefinition();
            case Resource.InternalType.StackLevelConfiguration -> new StackLevelConfigurationResourceDefinition();
            case Resource.InternalType.StackService -> new StackServiceResourceDefinition();
            case Resource.InternalType.StackServiceComponent -> new StackServiceComponentResourceDefinition();
            case Resource.InternalType.StackServiceComponentDependency -> new StackDependencyResourceDefinition();
            case Resource.InternalType.StackConfiguration -> new StackConfigurationResourceDefinition();
            case Resource.InternalType.StackConfigurationDependency -> new StackConfigurationDependencyResourceDefinition();
            case Resource.InternalType.Extension -> new ExtensionResourceDefinition();
            case Resource.InternalType.ExtensionVersion -> new ExtensionVersionResourceDefinition();
            case Resource.InternalType.ExtensionLink -> new ExtensionLinkResourceDefinition();
            case Resource.InternalType.OperatingSystem -> new OperatingSystemResourceDefinition();
            case Resource.InternalType.Repository -> new RepositoryResourceDefinition();
            case Resource.InternalType.DRFeed -> new FeedResourceDefinition();
            case Resource.InternalType.DRTargetCluster -> new TargetClusterResourceDefinition();
            case Resource.InternalType.DRInstance -> new InstanceResourceDefinition();
            case Resource.InternalType.Workflow -> new WorkflowResourceDefinition();
            case Resource.InternalType.Job -> new JobResourceDefinition();
            case Resource.InternalType.TaskAttempt -> new TaskAttemptResourceDefinition();
            case Resource.InternalType.RootService -> new RootServiceResourceDefinition();
            case Resource.InternalType.RootServiceComponent -> new RootServiceComponentResourceDefinition();
            case Resource.InternalType.RootServiceComponentConfiguration -> new SimpleResourceDefinition(Resource.Type.RootServiceComponentConfiguration, "configuration", "configurations", null, RootServiceComponentConfigurationService.DIRECTIVES_MAP);
            case Resource.InternalType.RootServiceHostComponent -> new RootServiceHostComponentResourceDefinition();
            case Resource.InternalType.ConfigGroup -> new ConfigGroupResourceDefinition();
            case Resource.InternalType.RequestSchedule -> new RequestScheduleResourceDefinition();
            case Resource.InternalType.View -> new ViewResourceDefinition();
            case Resource.InternalType.ViewVersion -> new ViewVersionResourceDefinition();
            case Resource.InternalType.ViewInstance -> {
                String viewName = mapIds.get(Resource.Type.View);
                String version = mapIds.get(Resource.Type.ViewVersion);
                Set<SubResourceDefinition> subResourceDefinitions = viewName == null || version == null ? Collections.emptySet() : ViewRegistry.getInstance().getSubResourceDefinitions(viewName, version);
                yield new ViewInstanceResourceDefinition(subResourceDefinitions);
            }
            case Resource.InternalType.ViewURL -> new ViewUrlResourceDefinition();
            case Resource.InternalType.Blueprint -> new BlueprintResourceDefinition();
            case Resource.InternalType.Recommendation -> new RecommendationResourceDefinition();
            case Resource.InternalType.Validation -> new ValidationResourceDefinition();
            case Resource.InternalType.HostComponentProcess -> new HostComponentProcessResourceDefinition();
            case Resource.InternalType.Permission -> new PermissionResourceDefinition();
            case Resource.InternalType.Alert -> new AlertResourceDefinition();
            case Resource.InternalType.AlertDefinition -> new AlertDefResourceDefinition();
            case Resource.InternalType.AlertHistory -> new AlertHistoryResourceDefinition();
            case Resource.InternalType.AlertGroup -> new AlertGroupResourceDefinition();
            case Resource.InternalType.AlertTarget -> new AlertTargetResourceDefinition();
            case Resource.InternalType.AlertNotice -> new AlertNoticeResourceDefinition();
            case Resource.InternalType.AmbariPrivilege -> new PrivilegeResourceDefinition(Resource.Type.AmbariPrivilege);
            case Resource.InternalType.ClusterPrivilege -> new PrivilegeResourceDefinition(Resource.Type.ClusterPrivilege);
            case Resource.InternalType.ViewPrivilege -> new PrivilegeResourceDefinition(Resource.Type.ViewPrivilege);
            case Resource.InternalType.UserPrivilege -> new PrivilegeResourceDefinition(Resource.Type.UserPrivilege);
            case Resource.InternalType.GroupPrivilege -> new PrivilegeResourceDefinition(Resource.Type.GroupPrivilege);
            case Resource.InternalType.ViewPermission -> new ViewPermissionResourceDefinition();
            case Resource.InternalType.ClientConfig -> new ClientConfigResourceDefinition();
            case Resource.InternalType.LdapSyncEvent -> new LdapSyncEventResourceDefinition();
            case Resource.InternalType.RepositoryVersion -> new RepositoryVersionResourceDefinition();
            case Resource.InternalType.CompatibleRepositoryVersion -> new CompatibleRepositoryVersionDefinition();
            case Resource.InternalType.HostStackVersion -> new ComponentStackVersionResourceDefinition(Resource.Type.HostStackVersion);
            case Resource.InternalType.ClusterStackVersion -> new ComponentStackVersionResourceDefinition(Resource.Type.ClusterStackVersion);
            case Resource.InternalType.Upgrade -> new UpgradeResourceDefinition();
            case Resource.InternalType.UpgradeGroup -> new SimpleResourceDefinition(Resource.Type.UpgradeGroup, "upgrade_group", "upgrade_groups", Resource.Type.UpgradeItem);
            case Resource.InternalType.UpgradeItem -> new SimpleResourceDefinition(Resource.Type.UpgradeItem, "upgrade_item", "upgrade_items", Resource.Type.Task);
            case Resource.InternalType.UpgradeSummary -> new SimpleResourceDefinition(Resource.Type.UpgradeSummary, "upgrade_summary", "upgrade_summary", new Resource.Type[0]);
            case Resource.InternalType.PreUpgradeCheck -> new SimpleResourceDefinition(Resource.Type.PreUpgradeCheck, "rolling_upgrade_check", "rolling_upgrade_checks", new Resource.Type[0]);
            case Resource.InternalType.Stage -> new SimpleResourceDefinition(Resource.Type.Stage, "stage", "stages", Resource.Type.Task);
            case Resource.InternalType.StackArtifact -> new SimpleResourceDefinition(Resource.Type.StackArtifact, "artifact", "artifacts", new Resource.Type[0]);
            case Resource.InternalType.Artifact -> new SimpleResourceDefinition(Resource.Type.Artifact, "artifact", "artifacts", new Resource.Type[0]);
            case Resource.InternalType.Theme -> new SimpleResourceDefinition(Resource.Type.Theme, "theme", "themes", new Resource.Type[0]);
            case Resource.InternalType.QuickLink -> new SimpleResourceDefinition(Resource.Type.QuickLink, "quicklink", "quicklinks", new Resource.Type[0]);
            case Resource.InternalType.Widget -> new WidgetResourceDefinition();
            case Resource.InternalType.WidgetLayout -> new WidgetLayoutResourceDefinition();
            case Resource.InternalType.ActiveWidgetLayout -> new ActiveWidgetLayoutResourceDefinition();
            case Resource.InternalType.HostKerberosIdentity -> new HostKerberosIdentityResourceDefinition();
            case Resource.InternalType.KerberosDescriptor -> new SimpleResourceDefinition(Resource.Type.KerberosDescriptor, "kerberos_descriptor", "kerberos_descriptors", new Resource.Type[0]);
            case Resource.InternalType.Credential -> new CredentialResourceDefinition();
            case Resource.InternalType.RoleAuthorization -> new SimpleResourceDefinition(Resource.Type.RoleAuthorization, "authorization", "authorizations", new Resource.Type[0]);
            case Resource.InternalType.UserAuthorization -> new SimpleResourceDefinition(Resource.Type.UserAuthorization, "authorization", "authorizations", new Resource.Type[0]);
            case Resource.InternalType.Setting -> new SimpleResourceDefinition(Resource.Type.Setting, "setting", "settings", new Resource.Type[0]);
            case Resource.InternalType.VersionDefinition -> new VersionDefinitionResourceDefinition();
            case Resource.InternalType.ClusterKerberosDescriptor -> new SimpleResourceDefinition(Resource.Type.ClusterKerberosDescriptor, "kerberos_descriptor", "kerberos_descriptors", null, Collections.singletonMap(BaseResourceDefinition.DirectiveType.READ, Arrays.asList("evaluate_when", "additional_services")));
            case Resource.InternalType.LoggingQuery -> new LoggingResourceDefinition();
            case Resource.InternalType.RemoteCluster -> new RemoteClusterResourceDefinition();
            case Resource.InternalType.Auth -> new AuthResourceDefinition();
            default -> throw new IllegalArgumentException("Unsupported resource type: " + type);
        };
    }
}

