/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Collections;
import java.util.List;

public class RequestScheduleResourceDefinition
extends BaseResourceDefinition {
    public RequestScheduleResourceDefinition() {
        super(Resource.Type.RequestSchedule);
    }

    @Override
    public String getPluralName() {
        return "request_schedules";
    }

    @Override
    public String getSingularName() {
        return "request_schedule";
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        return Collections.singletonList(new RequestScheduleHrefPostProcessor());
    }

    private class RequestScheduleHrefPostProcessor
    implements ResourceDefinition.PostProcessor {
        private RequestScheduleHrefPostProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            StringBuilder sb = new StringBuilder();
            String[] tokens = href.split("/");
            for (int i = 0; i < tokens.length; ++i) {
                String s = tokens[i];
                sb.append(s).append('/');
                if (!"clusters".equals(s)) continue;
                sb.append(tokens[i + 1]).append('/');
                break;
            }
            Object scheduleId = resultNode.getObject().getPropertyValue(RequestScheduleResourceDefinition.this.getClusterController().getSchema(Resource.Type.RequestSchedule).getKeyPropertyId(Resource.Type.RequestSchedule));
            sb.append("request_schedules/").append(scheduleId);
            resultNode.setProperty("href", sb.toString());
        }
    }
}

