/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Arrays;
import java.util.List;

public class RequestResourceDefinition
extends BaseResourceDefinition {
    public RequestResourceDefinition() {
        super(Resource.Type.Request, Resource.Type.Stage, Resource.Type.Task);
    }

    @Override
    public String getPluralName() {
        return "requests";
    }

    @Override
    public String getSingularName() {
        return "request";
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        return Arrays.asList(new RequestHrefPostProcessor(), new RequestSourceScheduleHrefPostProcessor());
    }

    private class RequestHrefPostProcessor
    implements ResourceDefinition.PostProcessor {
        private RequestHrefPostProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            Object requestId = resultNode.getObject().getPropertyValue(RequestResourceDefinition.this.getClusterController().getSchema(Resource.Type.Request).getKeyPropertyId(Resource.Type.Request));
            if (href.endsWith("/")) {
                href = href.substring(0, href.length() - 1);
            }
            StringBuilder sb = new StringBuilder();
            if (href.endsWith("/requests")) {
                sb.append(href);
                sb.append('/').append(requestId);
            } else {
                String[] tokens = href.split("/");
                Integer tokenCount = tokens.length;
                for (int i = 0; i < tokenCount; ++i) {
                    String fragment = tokens[i];
                    sb.append(fragment);
                    if (i < tokenCount - 1) {
                        sb.append('/');
                    }
                    if (!"clusters".equals(fragment) || i + 1 >= tokenCount) continue;
                    String clusterName = this.getClusterName(tokens[i + 1]);
                    sb.append(clusterName).append("/");
                    sb.append("requests/").append(requestId);
                    break;
                }
            }
            resultNode.setProperty("href", sb.toString());
        }

        private String getClusterName(String token) {
            int pos = token.indexOf(63);
            if (pos > 0) {
                return token.substring(0, pos);
            }
            return token;
        }
    }

    private class RequestSourceScheduleHrefPostProcessor
    implements ResourceDefinition.PostProcessor {
        private RequestSourceScheduleHrefPostProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            Object scheduleId;
            StringBuilder sb = new StringBuilder();
            String[] toks = href.split("/");
            for (int i = 0; i < toks.length; ++i) {
                String s = toks[i];
                sb.append(s).append('/');
                if (!"clusters".equals(s)) continue;
                sb.append(toks[i + 1]).append('/');
                break;
            }
            if ((scheduleId = resultNode.getObject().getPropertyValue("Requests/request_schedule/schedule_id")) != null) {
                sb.append("request_schedules/").append(scheduleId);
                resultNode.getObject().setProperty("Requests/request_schedule/href", sb.toString());
            }
        }
    }
}

