/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpackResourceDefinition
extends BaseResourceDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(MpackResourceDefinition.class);

    public MpackResourceDefinition() {
        super(Resource.Type.Mpack);
    }

    @Override
    public String getPluralName() {
        return "mpacks";
    }

    @Override
    public String getSingularName() {
        return "mpack";
    }

    @Override
    public Set<SubResourceDefinition> getSubResourceDefinitions() {
        HashSet<SubResourceDefinition> setChildren = new HashSet<SubResourceDefinition>();
        setChildren.add(new SubResourceDefinition(Resource.Type.StackVersion, null, false));
        return setChildren;
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        ArrayList<ResourceDefinition.PostProcessor> listProcessors = new ArrayList<ResourceDefinition.PostProcessor>();
        listProcessors.add(new MpackHrefProcessor());
        listProcessors.add(new MpackPostProcessor());
        return listProcessors;
    }

    private class MpackHrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private MpackHrefProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            if (((String)href).contains("/stacks/")) {
                ResourceImpl mpack = (ResourceImpl)resultNode.getObject();
                Map<String, Map<String, Object>> mapInfo = mpack.getPropertiesMap();
                Map<String, Object> mpackInfo = mapInfo.get("MpackInfo");
                int idx = ((String)href).indexOf("stacks/");
                Long mpackId = (Long)mpackInfo.get("id");
                href = ((String)href).substring(0, idx) + "mpacks/" + mpackId;
                resultNode.setProperty("href", href);
            } else {
                super.process(request, resultNode, (String)href);
            }
        }
    }

    private class MpackPostProcessor
    implements ResourceDefinition.PostProcessor {
        private MpackPostProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            if (href.contains("/stacks/")) {
                resultNode.setName("mpack");
            }
        }
    }
}

