/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.Schema;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HostComponentResourceDefinition
extends BaseResourceDefinition {
    public HostComponentResourceDefinition() {
        super(Resource.Type.HostComponent);
    }

    @Override
    public String getPluralName() {
        return "host_components";
    }

    @Override
    public String getSingularName() {
        return "host_component";
    }

    @Override
    public Set<SubResourceDefinition> getSubResourceDefinitions() {
        HashSet<SubResourceDefinition> setSubResources = new HashSet<SubResourceDefinition>();
        setSubResources.add(new SubResourceDefinition(Resource.Type.Component, Collections.singleton(Resource.Type.Service), false));
        setSubResources.add(new SubResourceDefinition(Resource.Type.HostComponentProcess));
        return setSubResources;
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        ArrayList<ResourceDefinition.PostProcessor> listProcessors = new ArrayList<ResourceDefinition.PostProcessor>();
        listProcessors.add(new HostComponentHrefProcessor());
        listProcessors.add(new HostComponentHostProcessor());
        return listProcessors;
    }

    private class HostComponentHrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private HostComponentHrefProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            if (!((String)href).contains("/hosts/")) {
                Resource r = resultNode.getObject();
                Schema schema = ClusterControllerHelper.getClusterController().getSchema(r.getType());
                Object host = r.getPropertyValue(schema.getKeyPropertyId(Resource.Type.Host));
                Object hostComponent = r.getPropertyValue(schema.getKeyPropertyId(r.getType()));
                int idx = ((String)href).indexOf("clusters/") + "clusters/".length();
                idx = ((String)href).indexOf("/", idx) + 1;
                href = ((String)href).substring(0, idx) + "hosts/" + host + "/host_components/" + hostComponent;
                resultNode.setProperty("href", href);
            } else {
                super.process(request, resultNode, (String)href);
            }
        }
    }

    private class HostComponentHostProcessor
    implements ResourceDefinition.PostProcessor {
        private HostComponentHostProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            if (request.getResource().getResourceDefinition().getType() == HostComponentResourceDefinition.this.getType()) {
                String nodeHref = resultNode.getStringProperty("href");
                resultNode.getObject().setProperty(PropertyHelper.getPropertyId("host", "href"), nodeHref.substring(0, nodeHref.indexOf("/host_components/")));
            }
        }
    }
}

