/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.List;

public class ConfigurationResourceDefinition
extends BaseResourceDefinition {
    public ConfigurationResourceDefinition() {
        super(Resource.Type.Configuration);
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        List<ResourceDefinition.PostProcessor> listProcessors = super.getPostProcessors();
        listProcessors.add(new HrefProcessor());
        return listProcessors;
    }

    @Override
    public String getPluralName() {
        return "configurations";
    }

    @Override
    public String getSingularName() {
        return "configuration";
    }

    private class HrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private HrefProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            if (resultNode.getObject().getType() == Resource.Type.Configuration) {
                if (!((String)href).endsWith("/")) {
                    href = (String)href + "/";
                }
                String clustersToken = "/clusters";
                int idx = ((String)href).indexOf(clustersToken) + clustersToken.length() + 1;
                idx = ((String)href).indexOf("/", idx) + 1;
                String type = (String)resultNode.getObject().getPropertyValue("type");
                String tag = (String)resultNode.getObject().getPropertyValue("tag");
                href = ((String)href).substring(0, idx) + "configurations?type=" + type + "&tag=" + tag;
                resultNode.setProperty("href", href);
            } else {
                super.process(request, resultNode, (String)href);
            }
        }
    }
}

