/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.Schema;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigGroupResourceDefinition
extends BaseResourceDefinition {
    public ConfigGroupResourceDefinition() {
        super(Resource.Type.ConfigGroup);
    }

    @Override
    public String getPluralName() {
        return "config_groups";
    }

    @Override
    public String getSingularName() {
        return "config_group";
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        List<ResourceDefinition.PostProcessor> listProcessors = super.getPostProcessors();
        listProcessors.add(new ConfigGroupHrefProcessor());
        return listProcessors;
    }

    private class ConfigGroupHrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private ConfigGroupHrefProcessor() {
            super(ConfigGroupResourceDefinition.this);
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            if (resultNode.getObject().getType() == Resource.Type.ConfigGroup) {
                Resource r = resultNode.getObject();
                Schema schema = ClusterControllerHelper.getClusterController().getSchema(r.getType());
                Object clusterId = r.getPropertyValue(schema.getKeyPropertyId(Resource.Type.Cluster));
                Map<String, Object> configGroup = r.getPropertiesMap().get("ConfigGroup");
                String partialUrl = href.substring(0, href.indexOf("/clusters/") + "/clusters/".length()) + clusterId;
                for (Map.Entry<String, Object> entry : configGroup.entrySet()) {
                    String idx;
                    if (entry.getKey().contains("hosts") && entry.getValue() != null) {
                        Set hostSet = (Set)entry.getValue();
                        for (Map hostMap : hostSet) {
                            idx = partialUrl + "/hosts/" + hostMap.get("host_name");
                            hostMap.put("href", idx);
                        }
                        continue;
                    }
                    if (!entry.getKey().contains("desired_configs") || entry.getValue() == null) continue;
                    Set configSet = (Set)entry.getValue();
                    for (Map configMap : configSet) {
                        idx = partialUrl + "/configurations?type=" + configMap.get("type") + "&tag=" + configMap.get("tag");
                        configMap.put("href", idx);
                    }
                }
            } else {
                super.process(request, resultNode, href);
            }
        }
    }
}

