/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.Schema;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ComponentResourceDefinition
extends BaseResourceDefinition {
    public ComponentResourceDefinition() {
        super(Resource.Type.Component);
    }

    @Override
    public String getPluralName() {
        return "components";
    }

    @Override
    public String getSingularName() {
        return "component";
    }

    @Override
    public Set<SubResourceDefinition> getSubResourceDefinitions() {
        return Collections.singleton(new SubResourceDefinition(Resource.Type.HostComponent, Collections.singleton(Resource.Type.Host), true));
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        List<ResourceDefinition.PostProcessor> listProcessors = super.getPostProcessors();
        listProcessors.add(new ComponentHrefProcessor());
        return listProcessors;
    }

    private class ComponentHrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private ComponentHrefProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            TreeNode<Resource> parent = resultNode.getParent();
            if (parent.getParent() != null && parent.getParent().getObject().getType() == Resource.Type.HostComponent) {
                Resource r = resultNode.getObject();
                Schema schema = ClusterControllerHelper.getClusterController().getSchema(r.getType());
                Object serviceId = r.getPropertyValue(schema.getKeyPropertyId(Resource.Type.Service));
                Object componentId = r.getPropertyValue(schema.getKeyPropertyId(r.getType()));
                href = ((String)href).substring(0, ((String)href).indexOf("/hosts/") + 1) + "services/" + serviceId + "/components/" + componentId;
                resultNode.setProperty("href", href);
            } else {
                super.process(request, resultNode, (String)href);
            }
        }
    }
}

